@extends('site.layout.layout')

@section('url'){{URL::to('/')}}/{{App::getLocale()}}/profile @stop
@section('title'){{ __('app.profile') }} @stop
@section('image'){{URL::to('/')}}/img/750x500/{{$setting->logo}} @stop
@section('description'){{\App\Http\Helpers\Helpers::stringReplace('',3)}} @stop

@section('css')
<style>
section {
    padding: 2em;
    display: flex;
    justify-content: center;
}

#profileSettings ul {
    background: #F8F8F8;
    padding: 0;
    display: flex;
    justify-content: center;
    width: 100%;

}
#profileSettings ul li a {
    border-radius: 0;
    background-color: #f8f8f8;
    color: #000;
    min-width: 170px;
    height: 50px;
    text-align: center;
    transition: .3s ease-in-out;
    line-height: 35px;

}
#profileSettings ul li.active a{
    background: #8fc525;
    color: #fff;
}
.profileContent .card img {
  height: 120px;
    width: 120px;
    margin: 0 auto;
    margin-top: 15px;
    border: unset;
    border-radius: 50%;


}
.profileContent .card.card-aside {
    border-top-left-radius: 30px;
    overflow: hidden;
    padding: 0;
    border: 0;

}
.profileContent .card {
    background: #fff;
    box-shadow: 1px 1px 20px 2px #e2e3e7;
    border: 0;

}
a.rat,
a.show_voice,
a.showDetails,
a.editProfile {
    background: #1a2b57;
    border-radius: 100%;
    padding: 9px 10px;
    font-size: 20px;
    display: flex;
    justify-content: center;
    align-items: center;
    color: #fff;
}

.required{
    color: red;
}
.swal2-container.swal2-rtl.swal2-center.swal2-backdrop-show {
    z-index: 99999999999 !important;
}

.card {
    position: relative;
    display: -ms-flexbox;
    display: flex;
    -ms-flex-direction: column;
    flex-direction: column;
    min-width: 0;
    word-wrap: break-word;
    background-color: #fff;
    background-clip: border-box;
    border: 1px solid rgba(0,0,0,.125);
    border-radius: 0.25rem;
}
.card-header {
    padding: 0.75rem 1.25rem;
    margin-bottom: 0;
    background-color: rgba(0,0,0,.03);
    border-bottom: 1px solid rgba(0,0,0,.125);
}
.card-header:first-child {
    border-radius: calc(0.25rem - 1px) calc(0.25rem - 1px) 0 0;
}
.card-body {
    -ms-flex: 1 1 auto;
    flex: 1 1 auto;
    padding: 1.25rem;
}

tr .remove-btn {
    position: relative;
    display: inline-block;
    font-size: 18px;
    color: red;
    width: 40px;
    height: 40px;
    line-height: 40px;
    border-radius: 50px;
    text-align: center;
    border: 1px solid red;
    -webkit-transition: all 500ms ease;
    -ms-transition: all 500ms ease;
    -o-transition: all 500ms ease;
    -moz-transition: all 500ms ease;
    transition: all 500ms ease;
}
.wpcf7-form input, .wpcf7-form textarea, .wpcf7-form select {
    border: 1px solid #ccc !important;
}
.pull-right {
    float: left;
}
.btn_save_page{
    background-color: #1a2b57;

}

#add_rating i.far,#add_rating i.fas{
    display: inline-block;
    font: normal normal normal 14px / 1 FontAwesome;
    font-size: inherit;
    text-rendering: auto;
    -webkit-font-smoothing: antialiased;
    width: 30px;
    font-size: 30px;

}

#tbodyRating i.far,#tbodyRating i.fas{
    display: inline-block;
    font: normal normal normal 14px / 1 FontAwesome;
    font-size: inherit;
    text-rendering: auto;
    -webkit-font-smoothing: antialiased;
    width: 15px;
    font-size: 15px;

}
</style>
@endsection
@section('content')
<div class="ttm-page-title-row">
    <div class="ttm-page-title-row-inner ttm-textcolor-white">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-12">
                    <div class="page-title-heading">
                        <h2 class="title">{{ __('app.profile') }}</h2>
                    </div>
                    <div class="breadcrumb-wrapper">
                        {{-- <span> --}}
                            {{-- <a title="Homepage" href="{{URL::to('/')}}">{{ __('app.home') }}</a> --}}
                        {{-- </span> --}}
                        {{-- <span class="ttm-bread-sep">&nbsp;&gt;&nbsp;</span> --}}
                        {{-- <span class="current">{{$data['static']->title}}</span> --}}
                    </div>
                </div>
            </div>
        </div>
    </div>                    
</div>
<div class="site-main">
    <div class="ttm-row why_choose2-section clearfix">
        <div class="container">
            <div class="row justify-content-center profileContent">
                <div class="col-md-4">
                    <div class=" profile-data float-right" style="width: 100%;">
                        <div class="card card-aside">
        
                            <img src="/uploads/{{\Auth::guard('clients')->user()->img}}" class="card-img-top img_profile" alt=""
                            style="
                                width: 70%;
                                margin: 0 auto;
                                margin-top: 20px;
                                border-radius: 50%;
                                height: 250px;
                            ">
                            <div class="card-body" style="font-size: 13px;">
                                <bdo dir="rtl"></bdo>
                                <table class="table table-borderless text-right">
                                    <tbody>
                                        <tr>
                                        <td><b> {{ __('lang.name') }}: </b></td>
                                        <td class="p_name"> {{\Auth::guard('clients')->user()->name}} </td>
                                        </tr>
                                        <tr>
                                            <td><b> {{ __('lang.mobile') }}:</b></td>
                                            <td class="p_mobile" style="direction: ltr;"> {{\Auth::guard('clients')->user()->mobile}}</td>
                                        </tr>
                                        <tr>
                                        <td><b>{{ __('lang.email') }}:</b></td>
                                        <td class="p_email"> {{\Auth::guard('clients')->user()->email}}</td>
                                        </tr>
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-8">
                    <div class="ttm-tabs tabs-style-01" data-effect="fadeIn">
                        <ul class="tabs clearfix">
                            <li class="tab active"><a href="#"> {{ __('app.Main_data') }}  </a></li>
                            <li class="tab"><a href="#" id="my_subscriptions"> اشتراكاتي  </a></li>
                            <li class="tab"><a href="#"> السجل المالي   </a></li>

                            <li id="logout"><a href="{{URL::to('/')}}/logout" >  {{ __('app.logout') }} </a></li>
                        </ul>
                        <div class="content-tab ">
                            
                            <div class="content-inner active">
                                <div class="card card-main">
                                    <div class="card-header">
                                        <h4 class="text-right">  {{ __('lang.profile') }}
                                            <a title=" {{ __('lang.Edit_profile') }}"   data-id="{{\Auth::guard('clients')->user()->id}}" class="pull-right update editProfile" href="javascript:void(0);">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                        </h4>
                                    </div>
                                    <div class="card-body">
                                        <div class=" table-responsive">
                                            <table class="table table-borderless">
                                                <thead>
                                                    <tr>
                                                        <td style="width: 20%;"><b> {{ __('lang.name') }}:</b></td>
                                                        <td class="p_name">  {{\Auth::guard('clients')->user()->name}}  </td>
                                                    </tr>
                                                    <tr>
                                                        <td><b>{{ __('lang.email') }} :</b></td>
                                                        <td class="p_email"> {{\Auth::guard('clients')->user()->email}}</td>
                                                    </tr>
                                                    <tr>
                                                        <td><b>{{ __('lang.mobile') }} :</b></td>
                                                        <td class="p_mobile" style="direction: ltr;">{{\Auth::guard('clients')->user()->mobile}}</td>
                                                    </tr>
                                                    {{-- <tr>
                                                        <td><b>{{ __('app.gender') }} :</b></td>
                                                        <td class="p_gender" style="direction: ltr;">
                                                            @if(\Auth::guard('clients')->user()->gender == 1)
                                                                {{ __('app.male') }}
                                                            @elseif(\Auth::guard('clients')->user()->gender == 2)
                                                                {{ __('app.female') }}
                                                            @endif
                                                        </td>
                                                    </tr> --}}
                                                    
                                                    <tr>
                                                        <td><b>{{ __('app.dob') }} :</b></td>
                                                        <td class="p_dob" style="direction: ltr;">{{\Auth::guard('clients')->user()->dob}}</td>
                                                    </tr>
                                                    {{-- name_Degree --}}
                                                    {{-- <tr>
                                                        <td><b>{{ __('app.governorate') }} :</b></td>
                                                        <td class="p_governorate" style="direction: ltr;">{{$data['clients']->name_governorate}}</td>
                                                    </tr> --}}
                                                    {{-- <tr>
                                                        <td><b>{{ __('app.city') }} :</b></td>
                                                        <td class="p_city" style="direction: ltr;">{{$data['clients']->name_city}}</td>
                                                    </tr> --}}
                                                    {{-- <tr>
                                                        <td><b>{{ __('app.title') }} :</b></td>
                                                        <td class="p_title" style="direction: ltr;">{{\Auth::guard('clients')->user()->title}}</td>
                                                    </tr> --}}
                                                    
            
                                                    <tr>
                                                        <td><b>{{ __('app.Degree') }} :</b></td>
                                                        <td class="p_Degree" style="direction: ltr;">{{$data['clients']->name_Degree}}</td>
                                                    </tr>
                                                    {{-- <tr>
                                                        <td><b>{{ __('app.Specialization') }} :</b></td>
                                                        <td class="p_Specialization" style="direction: ltr;">{{\Auth::guard('clients')->user()->Specialization}}</td>
                                                    </tr> --}}
                                                   
            
            
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="content-inner" style="display: none;">
                                <div class="card card-main">
                                    <div class="card-header">
                                            <h4>  اشتراكاتي  </h4>
                                    </div>
                                    <div class="card-body"id="table-container">
                                        @include('site.sub_profile.table-data-Favorite')
                                        {{-- قيد البرمجة  --}}
                                    </div>
                                </div>
                            </div>
                            <div class="content-inner" style="display: none;">
                                <div class="card card-main">
                                    <div class="card-header">
                                            <h4>  السجل المالي  </h4>
                                    </div>
                                    <div class="card-body"id="table-container">
                                        @include('site.sub_profile.table-data-donation')
                                        {{-- قيد البرمجة  --}}
                                    </div>
                                </div>
                            </div>
                        </div>


                        
                    </div>
                </div>
            </div>
        </div>
    </div>

    
</div>


@include('site.sub_profile.update_clint')

@endsection
@section('js')
<script>
    // onkeypress="return isNumberKey(event)"
    function isNumberKey(evt){
        var charCode = (evt.which) ? evt.which : event.keyCode
        if (charCode > 31 && (charCode < 48 || charCode > 57))
            return false;
        return true;
    }
    $(document).on('click', '#update_clint .close', function (e) {
        $('#update_clint').hide();
    });
    $(document).on('click', '#update_clint #close', function (e) {
        $('#update_clint').hide();
    });

    $(document).on('click', '#add_rating .close', function (e) {
        $('#add_rating').hide();
    });
    $(document).on('click', '#add_rating #close', function (e) {
        $('#add_rating').hide();
    });

    
    
    $(document).ready(function(){
        var new_tap = window.location.hash
        if(new_tap === '#my_subscriptions') {
            $('#my_subscriptions').click();
        }
        rating();
        ratingclint();
    })

    /*************************************************/
    $(document).on('change','#form_update_clint #governorate',function(e){
        var id = $(this).val();
        $('#form_update_clint #loading').show();
        $.ajax({
            url: "{{URL::to('/')}}/get_city",
            type: "get",
            dataType: "JSON",
            data: {
                id: id
            },
            success: function(data){
                $('#form_update_clint #loading').hide();
                if(data['status'] == true){
                    $('#form_update_clint #city').empty().html(data.data);
                }else{
                swal({
                        title: "",
                        text: data["data"],
                        type: "error",
                        showCancelButton: false,
                        confirmButtonColor: "#DD6B55",
                        confirmButtonText: "حسنا",
                        cancelButtonText: "الغاء",
                        closeOnConfirm: true,
                        closeOnCancel: true
                    });
                }
            },
            complete: function () {

            }
        });
    });
        $(document).on('click', '.update', function (e) {
            e.preventDefault();
            $('#form_update_clint').find("#loading").hide();

            var id = $(this).data('id');
            $.ajax({
                url: "{{URL::to('/')}}/edit_profile",
                type: "get",
                dataType: "JSON",
                data: {
                    id: id
                },
                success: function(data){
					if(data['status'] == true){
                    $('#form_update_clint').find(".id").val(data['data']['id']);
                    $('#form_update_clint').find(".name").val(data['data']['name']);
                    $('#form_update_clint').find(".email").val(data['data']['email']);
                    $('#form_update_clint').find(".mobile").val(data['data']['mobile']);

                    $('#form_update_clint').find(".gender").val(data['data']['gender']);
                    $('#form_update_clint').find(".dob").val(data['data']['dob']);
                    $('#form_update_clint').find(".governorate").val(data['data']['governorate']);
                    $('#form_update_clint').find(".city").empty().html(data['options']);

                    $('#form_update_clint').find(".title").val(data['data']['title']);
                    $('#form_update_clint').find(".Degree").val(data['data']['Degree']);
                    $('#form_update_clint').find(".Specialization").val(data['data']['Specialization']);
                    
                    $('#form_update_clint').find(".city").val(data['data']['city']);
                    $('#form_update_clint').find(".password").val('');

                    }
                },
                complete: function () {
                    $('#update_clint').show();
                },
            })
        });

</script>
<script>
  $('.form_update_clint').on('submit', function(e){
                    e.preventDefault();
                    var formData = new FormData(this);

                    // $('#update_clint #loading').show();
                    $('#preloader').css('display', '');
                    $('#status').css('display', '');
                    

                        $.ajax({
                            url: "{{URL::to('/')}}/update_profile",
                            type: "POST",
                            dataType: "JSON",
                            cache:false,
                            contentType: false,
                            processData: false,
                            data: formData,
                            success: function(data) {
                                // $('#update_clint #loading').hide();
                                $('#preloader').css('display','none');
                                $('#status').css('display','none');
                            if (data["status"] == true) {

                                Swal.fire({
                                    title: "",
                                    text: data["data"],
                                    type: "success",
                                    showCancelButton: false,
                                    confirmButtonColor: "#0c3591",
                                    confirmButtonText: '{{__('lang.ok')}}',
                                    cancelButtonText: '{{__('lang.cancel')}}',
                                    closeOnConfirm: true,
                                    closeOnCancel: true
                                });



                                        $('#update_clint').hide();
                                        $('.p_name').html(data['client']['name']);
                                        $('.p_email').html(data['client']['email']);
                                        $('.p_mobile').html(data['client']['mobile']);
                                        if(data['client']['gender'] == 1){
                                            $('.p_gender').html("{{__('app.male')}}");
                                        }
                                        if(data['client']['gender'] == 2){
                                            $('.p_gender').html("{{__('app.female')}}");
                                        }
                                        $('.p_dob').html(data['client']['dob']);
                                        $('.p_governorate').html(data['client']['name_governorate']);
                                        $('.p_city').html(data['client']['name_city']);
                                        $('.p_title').html(data['client']['title']);
                                        $('.p_Degree').html(data['client']['name_Degree']);
                                        $('.p_Specialization').html(data['client']['Specialization']);

                                        $('.img_profile').attr('src','/uploads/'+data['client']['img']);
                                        
                                        // $(".password").val('');
                                        $(".photo").val('');
                            } else {
                                if(data['data_validator']!=null){
                                    var dt = '<ul>';
                                    $.each(data["data_validator"], function (key, value) {
                                        dt = dt + '<li>' + value + '</li>';
                                    })
                                    dt =dt+ '</ul>';
                                toastr["error"](dt)

                        }else{
                        // toastr["error"](data["data"])
                        Swal.fire({
                            title: "",
                            text: data["data"],
                            type: "error",
                            showCancelButton: false,
                            confirmButtonColor: "#0c3591",
                            confirmButtonText: '{{__('lang.ok')}}',
                            cancelButtonText: '{{__('lang.cancel')}}',
                            closeOnConfirm: true,
                            closeOnCancel: true
                        });

                            }


                            }

                            }
                        });


            });
    </script>
    <script>
    $('body').on('click','.addToFavorite',function(){
        // $('#addNewpageForm_tocard #loading').show();
        $('#preloader').css('display', '');
        $('#status').css('display', '');
        

        var id = $(this).data('id');
        $this = $(this);
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url: "{{URL::to('/')}}/removeCours",
            type: "POST",
            dataType: "JSON",
            data:{
               id:id
               },
            success: function(data) {

                $('#preloader').css('display','none');
                $('#status').css('display','none');
              if (data["status"] == true) {

                        Swal.fire({
                            title: "",
                            text: data['data'],
                            type: "success",
                            showCancelButton: false,
                            confirmButtonColor: "#0c3591",
                            confirmButtonText: '{{__('lang.ok')}}',
                            cancelButtonText: '{{__('lang.cancel')}}',
                            closeOnConfirm: true,
                            closeOnCancel: true
                        });

                    $("#table-container").empty().html(data["view"]);

              } else {

                 Swal.fire({
                    title: "",
                    text: data["data"],
                    icon: "error",
                    showCancelButton: false,
                    confirmButtonColor: "#0c3591",
                    confirmButtonText: '{{__('lang.ok')}}',
                    cancelButtonText: '{{__('lang.cancel')}}',
                    closeOnConfirm: true,
                    closeOnCancel: true
                });


              }

            }
        });

    });
    $('body').on('click','#logout',function(){
        window.location.href = "{{URL::to('/')}}/logout";
    });
    
    </script>


<script>

        $(document).on('click', '.add_client_rating', function (e) {
            e.preventDefault();
            var id = $(this).data('id');
		    $('#add_rating #addNewrating').find(".notess").val('');
            $('#add_rating #addNewrating').find(".clint_id").val(id);
            $('#add_rating .sui-rating-selected').css('width', '0');
            ratingclint();
            $('#add_rating').show();
        });
        $('#add_rating .addNewrating').on('submit', function(e){
            e.preventDefault();
            var clint_id =$("#add_rating .clint_id").val();
            var notes =$("#add_rating #notess").val();
            var rating_client =$("#add_rating #add_rating_client").val();

            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
            	url: "{{URL::to('/')}}/addrating",
                type: "POST",
                dataType: "JSON",
                data:{
                   id:clint_id,
                   notes:notes,
                   rating_client:rating_client,
                  },
                success: function(data) {
                  if (data["status"] == true) {
                        Swal.fire({
                                title: "",
                                text: data['data'],
                                type: "success",
                                showCancelButton: false,
                                confirmButtonColor: "#0c3591",
                                confirmButtonText: '{{__('lang.ok')}}',
                                cancelButtonText: '{{__('lang.cancel')}}',
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                              $('#add_rating').hide();
                              $(".notess").val('');
                              $('.sui-rating-selected').css('width', '0');
                            //   window.location.reload();
                            $("#table-container").empty().html(data["view"]);


                  } else {
                     if(data['data_validator']!=null){
                        var dt = '<ul>';
                         $.each(data["data_validator"], function (key, value) {
                             dt = dt + '<li>' + value + '</li>';
                         })
                         dt =dt+ '</ul>';

                            Swal.fire({
                                title: "",
                                text: dt,
                                type: "success",
                                showCancelButton: false,
                                confirmButtonColor: "#0c3591",
                                confirmButtonText: '{{__('lang.ok')}}',
                                cancelButtonText: '{{__('lang.cancel')}}',
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });

                        }else{
                            Swal.fire({
                                title: "",
                                text: data['data'],
                                type: "success",
                                showCancelButton: false,
                                confirmButtonColor: "#0c3591",
                                confirmButtonText: '{{__('lang.ok')}}',
                                cancelButtonText: '{{__('lang.cancel')}}',
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                        }
                                    

                  }

                }
            });

    });






    function ratingclint(){
        $.each($('.client_rating_add'), function (indexInArray, valueOfElement) {
        $(this).rating({
            "click":function(e){
                        $("#add_rating_client").val(e.stars);
                    },
            "value": $(this).data('rating'),
            "half":true
          });
        });
    }
    function rating(){
        $.each($('.client_rating'), function (indexInArray, valueOfElement) {
          $(this).rating({
            "value": $(this).data('rating'),
            "readonly":true,
            "half":true
          });
        });
    }
</script>
@endsection