@extends('site.layout.layout')
@section('url'){{URL::to('/')}}/{{App::getLocale()}}/partners @stop
@section('title'){{$data['static']->title}} @stop
@section('image'){{URL::to('/')}}/img/750x500/{{$setting->logo}} @stop
@section('description'){{\App\Http\Helpers\Helpers::stringReplace($data['static']->details,3)}} @stop

@section('css')
<style>

</style>
@endsection
@section('content')
<section class="page-title">
    <div class="container">
        <div class="row">
            <div class="col col-xs-12">
                <h2>{{$data['static']->title}}</h2>
                <ol class="breadcrumb">
                    <li class="">{{$data['static']->title}}</li>
                    <li class="float-right"><a href="{{URL::to('/')}}/{{App::getLocale()}}}">{{ __('app.home') }}</a></li>
                </ol>
            </div>
        </div> 
    </div> 
</section>   
    <section class="section-padding partners" style="padding: 30px 0;">
        <h2 class=""> </h2>
        <div class="container">
            <div class="row">
                <div class="col col-xs-12">
                    <div class="partners-slider" style="height: 120px;">
                        @foreach ($data['institutions'] as $item)
                            <div class="grid" onclick="location.href='{{$item->url}}';">
                                <img src="{{URL::to('/')}}/uploads/{{$item->photo}}" alt="{{$item->title}}">
                                {{-- <img src="{{URL::to('/')}}/img/546x450/{{$item->photo}}" alt="{{$item->title}}"> --}}
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </section>



@endsection
@section('js')
<script>


</script>
@endsection