<!doctype html>
<html class="no-js" lang="ar" dir="rtl">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta charset="utf-8">
    <title>@yield('title')</title>
    <meta name="robots" content="ALL, INDEX, FOLLOW" />
    <meta property="og:url" content="@yield('url')" />
    <meta property="og:type" content="article" />
    <meta property="og:title" content="@yield('title')" />
    <meta property="og:description" content="@yield('description')" />
    <meta property="og:image" content="@yield('image')">
    @yield('posts')
    
    <meta property="og:site_name" content="@yield('title')" />
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:title" content="@yield('title')" />
    <meta name="twitter:site" content="@khososy" />
    <meta name="twitter:creator" content="@khososy" />
    <meta name="twitter:description" content="@yield('description')" />
    <meta name="twitter:image" content="@yield('image')" />
    <meta name="twitter:domain" content="{{URL::to('/')}}" />
    <meta name="twitter:url" content="@yield('url')" />
    <meta name="description" content="@yield('description')" />
    <meta name="keywords" content="{{\App\Http\Helpers\Helpers::stringReplace($settings->key_words,3)}}" /> 
    <meta name="author" content="pal-aif" />
    <meta name="rating" content="General" />
    <link rel="sitemap" type="application/xml" title="Sitemap" href="{{URL::to('/')}}/sitemap.xml" />
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <link rel="apple-touch-icon" sizes="180x180" href="{{URL::to('/')}}/site/assets/images/apple-touch-icon.png">
    <link rel="icon" type="image/png" sizes="32x32" href="{{URL::to('/')}}/site/assets/images/favicon-32x32.png">
    <link rel="icon" type="image/png" sizes="16x16" href="{{URL::to('/')}}/site/assets/images/favicon-16x16.png">

    <!-- favicon icon -->
    <link rel="shortcut icon" href="{{URL::to('/')}}/site/assets/images/favicon.png" />

    <!-- bootstrap -->
    <link rel="stylesheet" type="text/css" href="{{URL::to('/')}}/site/assets/css/bootstrap.min.css"/>

    <!-- fontawesome -->
    <link rel="stylesheet" type="text/css" href="{{URL::to('/')}}/site/assets/css/font-awesome.css"/>

    <!-- themify -->
    <link rel="stylesheet" type="text/css" href="{{URL::to('/')}}/site/assets/css/themify-icons.css"/>

    <!-- flaticon -->
    <link rel="stylesheet" type="text/css" href="{{URL::to('/')}}/site/assets/css/flaticon.css"/>

    <!-- slick -->
    <link rel="stylesheet" type="text/css" href="{{URL::to('/')}}/site/assets/css/slick.css">

    <!-- prettyphoto -->
    <link rel="stylesheet" type="text/css" href="{{URL::to('/')}}/site/assets/css/prettyPhoto.css">

    <!-- shortcodes -->
    <link rel="stylesheet" type="text/css" href="{{URL::to('/')}}/site/assets/css/shortcodes.css"/>

    <!-- main -->
    <link rel="stylesheet" type="text/css" href="{{URL::to('/')}}/site/assets/css/main.css"/>

    <!-- main -->
    <link rel="stylesheet" type="text/css" href="{{URL::to('/')}}/site/assets/css/megamenu.css"/>

    <!-- responsive -->
    <link rel="stylesheet" type="text/css" href="{{URL::to('/')}}/site/assets/css/responsive.css"/>

    <!-- style HFT -->
    <link rel="stylesheet" type="text/css" href="{{URL::to('/')}}/site/assets/css/main_ar.css"/>

    <!-- style Page -->
    @yield('css')
    <style>
        .site-main{
            min-height: 670px;
        }
    </style>
        <!---->


</head>
<body oncontextmenu="return false;">
    @php
        $url = \URL::to('/');
    @endphp
    <div class="page">
        <div id="preloader">
            <div id="status">&nbsp;</div>
        </div>
        <header id="masthead" class="header ttm-header-style-01">
            <div class="top_bar ttm-bgcolor-darkgrey ttm-textcolor-white clearfix">
                <div class="container">
                    <div class="row">
                        <div class="col-xl-12 d-flex flex-row align-items-center" style="padding: 14px 25px 14px 25px;">
                                @if (Auth::guard('clients')->check())
                                    <div class="top_bar_contact_item">
                                        <a href="{{URL::to('/')}}/profile">  الملف الشخصي   </a>
                                    </div>
                                    <div class="top_bar_contact_item  ml-auto">
                                        <a href="{{URL::to('/')}}/profile#my_subscriptions">  اشتراكاتي  </a>
                                    </div>

                                @elseif (Auth::guard('trainers')->check())
                                    <div class="top_bar_contact_item">
                                        <a href="{{URL::to('/')}}/profile_trainers">  الملف الشخصي   </a>
                                    </div>
                                    <div class="top_bar_contact_item  ml-auto">
                                        <a href="{{URL::to('/')}}/profile_trainers#my_courses">  دوراتي  </a>
                                    </div>
                                @else
                                    <div class="top_bar_contact_item">
                                        <a href="{{URL::to('/')}}/login"> تسجيل دخول </a>
                                    </div>
                                    <div class="top_bar_contact_item ml-auto">
                                        <a href="{{URL::to('/')}}/registration">   طلب الانضمام  </a>
                                    </div>
                                @endif
                                
                            <div class="top_bar_contact_item">
                                <div class="top_bar_social">
                                    <ul class="social-icons">
                                        @foreach ($social_links as $item)
                                        @php 
                                            $myArray = explode('-', $item->social);
                                            
                                        @endphp
                                            <li>
                                                <a class="tooltip-bottom" target="_blank" href="{{$item->url}}" data-tooltip="{{$myArray[1]}}" tabindex="-1">
                                                    <i class="fa {{$item->social}}"></i>
                                                </a>
                                            </li>
                                        @endforeach
                                        {{-- <li>
                                            <a class="tooltip-bottom" target="_blank" href="https://twitter.com" data-tooltip="Twitter" tabindex="-1">
                                                <i class="fa fa-twitter"></i>
                                            </a>
                                        </li>
                                        
                                        <li><a class="tooltip-bottom" target="_blank" href="https://www.linkedin.com" data-tooltip="Linkedin" tabindex="-1"><i class="fa fa-linkedin"></i></a>
                                        </li> --}}
                                    </ul>
                                </div>
                            </div>
                            {{-- <a class="ttm-btn ttm-btn-size-md ttm-btn-shape-square ttm-btn-style-fill ttm-btn-color-skincolor" href="#">
                                طلب الانضمام 
                            </a> --}}
                        </div>
                    </div>
                </div>
            </div>
            <div id="site-header-menu" class="site-header-menu ttm-bgcolor-white">
                <div class="site-header-menu-inner ttm-stickable-header">
                    <div class="container">
                        <div class="row">
                            <div class="col">
                                <div class="site-navigation d-flex flex-row">
                                    <div class="site-branding mr-auto">
                                        <a class="home-link" href="{{URL::to('/')}}" title="Uniaro" rel="home">
                                            <img id="logo-img" class="img-center lazyload" src="{{URL::to('/')}}/site/assets/images/logo.png" data-src="{{URL::to('/')}}/site/assets/images/logo.png" alt=" منصة خصوصي">
                                        </a>
                                    </div>
                                    <div class="btn-show-menu-mobile menubar menubar--squeeze">
                                        <span class="menubar-box">
                                            <span class="menubar-inner"></span>
                                        </span>
                                    </div>
                                    <nav class="main-menu menu-mobile" id="menu">
                                        <ul class="menu">
                                            <li class="mega-menu-item @if(Request::url() == $url )active-menu @endif">
                                                <a href="{{URL::to('/')}}" class="mega-menu-link no_icon"> الرئيسية </a>
                                            </li>
                                            <li class="mega-menu-item @if(Request::url() == $url.'/page/aboutus' ) active @endif ">
                                                <a href="{{URL::to('/')}}/page/aboutus" class="mega-menu-link no_icon"> من نحن  </a>
                                            </li>
                                            <li class="mega-menu-item @if(Request::url() == $url.'/Universities' ) active @endif">
                                                <a href="{{URL::to('/')}}/Universities" class="mega-menu-link no_icon">   الجامعات   </a>
                                            </li>
                                            <li class="mega-menu-item @if(Request::url() == $url.'/TrainingCourses' ) active @endif">
                                                <a href="{{URL::to('/')}}/TrainingCourses" class="mega-menu-link no_icon">  الدورات التدريبية   </a>
                                            </li>
                                            <li class="mega-menu-item @if(Request::url() == $url.'/page/contact_us' ) active @endif ">
                                                <a href="{{URL::to('/')}}/page/contact_us" class="mega-menu-link no_icon">   اتصل بنا    </a>
                                            </li>
                                        </ul>
                                    </nav>
                                    <div class="header_extra d-flex flex-row align-items-center justify-content-end">
                                        <div class="header_search">
                                            <a href="#" class="btn-default search_btn"><i class="ti ti-search"></i></a>
                                            <div class="header_search_content">
                                                
                                                <form id="searchbox"  method="POST" action="{{URL::to('/')}}/{{App::getLocale()}}/search">
                                                    <input class="search_query" type="text" id="search_query_top" name="search" placeholder=" ادخل كلمة البحث " value="">
                                                    <button type="submit" class="btn close-search"><i class="fa fa-search"></i></button>
                                                </form>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>

        @yield('content')

        <footer class="footer ttm-bgcolor-darkgrey ttm-textcolor-white clearfix">
            <div class="second-footer">
                <div class="bottom-footer-text text-center">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-12">
                                <ul id="menu-footer-menu" class="footer-nav-menu ttm-textcolor-white">
                                    <li><a href="{{URL::to('/')}}"> الرئيسية </a></li>
                                    <li><a href="{{URL::to('/')}}/page/aboutus"> من نحن </a></li>
                                    <li><a href="{{URL::to('/')}}/Universities">  الجامعات </a></li>
                                    <li><a href="{{URL::to('/')}}/TrainingCourses"> الدورات التدريبية </a></li>
                                    <li><a href="{{URL::to('/')}}/login">  تسجيل دخول    </a></li>
                                    <li><a href="{{URL::to('/')}}/profile">   الملف الشخصي     </a></li>
                                    <li><a href="{{URL::to('/')}}/my_subscriptions"> اشتراكاتي </a></li>
                                    <li><a href="{{URL::to('/')}}/page/contact_us">  اتصل بنا    </a></li>
                                    
                                </ul>
                            
                                <div class="text-center pb-15">
                                    جميع الحقوق محفوظة   &copy;<script>document.write(new Date().getFullYear());</script>   ل  <strong>  {{$settings->name}} </strong>   
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </footer>
        <a id="totop" href="#top">
            <i class="fa fa-angle-up"></i>
        </a>
    </div>
    <script src="{{URL::to('/')}}/site/assets/js/jquery.min.js"></script>
    <script src="{{URL::to('/')}}/site/assets/js/tether.min.js"></script>
    <script src="{{URL::to('/')}}/site/assets/js/bootstrap.min.js"></script> 
    <script src="{{URL::to('/')}}/site/assets/js/jquery.easing.js"></script>    
    <script src="{{URL::to('/')}}/site/assets/js/jquery-waypoints.js"></script>    
    <script src="{{URL::to('/')}}/site/assets/js/jquery-validate.js"></script> 
    <script src="{{URL::to('/')}}/site/assets/js/jquery.prettyPhoto.js"></script>
    <script src="{{URL::to('/')}}/site/assets/js/slick.min.js"></script>
    <script src="{{URL::to('/')}}/site/assets/js/numinate.min.js"></script>
    <script src="{{URL::to('/')}}/site/assets/js/imagesloaded.min.js"></script>
    <script src="{{URL::to('/')}}/site/assets/js/jquery-isotope.js"></script>
    <script src="{{URL::to('/')}}/site/assets/js/lazysizes.min.js"></script>
    <script src="{{URL::to('/')}}/site/assets/js/main.js"></script>
    <script src='{{URL::to('/')}}/site/assets/js/sweetalert.js'></script>
    <script src="{{URL::to('/')}}/site/assets/js/rating-star-icons/dist/rating.js"></script>

    <!-- Javascript end-->
    @yield('js')
</body>
</html>