<?php

namespace App\Http\Controllers\Admin;

use App\Models\Course as MyModel;
use App\Models\MyCourses;
use App\Models\Setting;
use App\Models\Video;
use App\Models\System_Constants;
use App\Models\Trainers;
use App\Models\Universities;
use Illuminate\Http\Request;
use ZipArchive;

use Hypweb\Flysystem\GoogleDrive\GoogleDriveAdapter;
use Illuminate\Filesystem\Filesystem;
use Illuminate\Support\Facades\Cache;
use League\Flysystem\Filesystem as FlysystemFilesystem;
use Storage;
use Google\Client;

class CourseController extends AdminController
{
    public function __construct()
    {
    }
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function index(Request $request)
    {
        $data['courses'] = MyModel::with('category')->orderBy('id', 'desc')->paginate(15);
        $s = new System_Constants();
        $data['lang'] = $s->constants('lang');
        $data['universities'] = Universities::orderBy('id', 'desc')->get();
        $data['courses_category'] = $s->constants('courses_category');
        if ($request->ajax()) {
            return view('admin.courses.table-data', compact('data'))->render();
        }
        return view('admin.courses.index', compact('data'));
    }
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function add(Request $request)
    {

        $hidden = $request->get('hidden');
        if ($hidden == 0) {
            $user_id = \Auth::user()->id;
            $title = $request->get('title');
            $details = $request->get('details');
            $lang = 1;
            $image = $request->get('image');
            $category_id = $request->get('category_id');
            $price = $request->get('price');

            $universities = $request->get('universities');
            $trainers = $request->get('trainers');

            if (isset($request['activeValue'])) {
                $status = 1;
            } else {
                $status = 0;
            }

            $rules = [
                'title' => 'required',
                'details' => 'required',
                'lang' => 'required',
                'category_id' => 'required',
                'image' => 'required',
                'price' => 'required',

                'universities' => 'required',
                'trainers' => 'required',

            ];


            $messages = [
                'title.required' => 'العنوان مطلوب',
                'details.required' => 'التفاصيل مطلوب',
                'lang.required' => 'اللغة مطلوبة',
                'category_id.required' => 'التصنيف مطلوب',
                'image.required' => 'الصورة مطلوبة',
                'price.required' => 'السعر مطلوب',

                'universities.required' => 'الجامعة مطلوب',
                'trainers.required' => 'المدرب مطلوب',

            ];

            $validator = \Validator::make(
                [
                    'title' => $title,
                    'details' => $details,
                    'lang' => $lang,
                    'category_id' => $category_id,
                    'image' => $image,
                    'price' => $price,

                    'universities' => $universities,
                    'trainers' => $trainers,

                ],
                $rules,
                $messages
            );

            if ($validator->fails()) {
                $all = collect($validator->errors()->getMessages())->map(function ($item) {
                    return $item[0];
                });
                $strs = [];
                foreach ($all as $value) {
                    $strs[] =  $value;
                }
                return response()->json(['status' => false, 'data' => implode(',', $strs)]);
            }

            if ($price <= 0) {
                return response()->json(['status' => false, 'data' => 'السعر الدورة أكبر من صفر']);
            }

            $item = new MyModel();
            $item->user_id = $user_id;
            $item->title = $title;
            $item->details = $details;
            $item->lang = $lang;
            $item->category_id = $category_id;
            $item->status = $status;
            $item->image = $image;
            $item->price = $price;

            $item->universities = $universities;
            $item->trainers = $trainers;

            $saved = $item->save();
            if (!$saved) {
                return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
            }
            return response()->json(['status' => true, 'data' => 'تمت عملية الإضافة']);
        } else {
            return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
        }
    }
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function edit(Request $request)
    {

        $id = $request->get('id');
        $item = MyModel::find($id);
        if ($item != '') {

            $select = '';
            $select = '<option value=""> اختر مدرب </option>';

            $data['Trainers'] = Trainers::where('status', 1)->where('universities', $item->universities)->orderBy('id', 'desc')->get();
            if ($data['Trainers'] and count($data['Trainers']) > 0) {
                foreach ($data['Trainers'] as $category) {

                    $selected = '';
                    if ($category->id  == $item->trainers) {
                        $selected = 'selected';
                    }
                    $select .= '<option value="' . $category->id . '"  ' . $selected . ' >' . $category->title_ar . '</option>';
                }
            }



            return response()->json(['status' => true, 'data' => $item, 'select' => $select]);
        } else {
            return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
        }
    }
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function UpdateStats(Request $request)
    {

        $id = $request->get('id');
        $item = MyModel::find($id);
        if ($item != '') {
            if ($item->status == 0) {
                $item->status = 1;
            } else {
                $item->status = 0;
            }
            $saved = $item->save();
            if (!$saved) {
                return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
            }
            return response()->json(['status' => true, 'data' => 'تم تعديل الحالة']);
        } else {
            return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
        }
    }
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function update(Request $request)
    {

        $hidden = $request->get('hidden');

        if ($hidden != 0) {
            $user_id = \Auth::user()->id;
            $title = $request->get('title');
            $details = $request->get('details');
            $lang = 1;
            $category_id = $request->get('category_id');
            $image = $request->get('image');
            $price = $request->get('price');
            $universities = $request->get('universities');
            $trainers = $request->get('trainers');
            if (isset($request['activeValue'])) {
                $status = 1;
            } else {
                $status = 0;
            }

            $rules = [
                'title' => 'required',
                'details' => 'required',
                'lang' => 'required',
                'category_id' => 'required',
                'price' => 'required',
                'universities' => 'required',
                'trainers' => 'required',
            ];

            $messages = [
                'title.required' => 'العنوان مطلوب',
                'details.required' => 'التفاصيل مطلوب',
                'lang.required' => 'اللغة مطلوبة',
                'category_id.required' => 'التصنيف مطلوب',
                'price.required' => 'السعر مطلوب',
                'universities.required' => 'الجامعة مطلوب',
                'trainers.required' => 'المدرب مطلوب',
            ];

            $validator = \Validator::make(
                [
                    'title' => $title,
                    'details' => $details,
                    'lang' => $lang,
                    'category_id' => $category_id,
                    'price' => $price,
                    'universities' => $universities,
                    'trainers' => $trainers,
                ],
                $rules,
                $messages
            );

            if ($validator->fails()) {
                $all = collect($validator->errors()->getMessages())->map(function ($item) {
                    return $item[0];
                });
                $strs = [];
                foreach ($all as $value) {
                    $strs[] =  $value;
                }
                return response()->json(['status' => false, 'data' => implode(',', $strs)]);
            }

            if ($price <= 0) {
                return response()->json(['status' => false, 'data' => 'السعر الدورة أكبر من صفر']);
            }

            $item = MyModel::find($hidden);


            if ($item != '') {
                $item->title = $title;
                $item->details = $details;
                $item->lang = $lang;
                $item->category_id = $category_id;
                $item->status = $status;
                $item->price = $price;
                if ($image) {
                    $item->image = $image;
                }
                $item->universities = $universities;
                $item->trainers = $trainers;
                $saved = $item->save();
                if (!$saved) {
                    return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
                }
                return response()->json(['status' => true, 'data' => 'تم تعديل البيانات']);
            } else {
                return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
            }
        }
    }
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function delete(Request $request)
    {
        $id = $request->get('id');
        $item = MyModel::find($id);
        if ($item != '') {
            $deleted = $item->delete();
            if (!$deleted) {
                return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
            }
            return response()->json(['status' => true, 'data' => 'تم الحذف بنجاح']);
        } else {
            return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
        }
    }
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function videos(Request $request)
    {
        $course_id = $request->get('course_id');
        $videos = Video::where('course_id', $course_id)->get();
        $view =  view('admin.courses.video-table-data', compact('videos'))->render();
        return response()->json(['status' => true, 'data' => $view]);
    }
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function addVideo(Request $request)
    {
        $course_id = $request->get('course_id');
        $title = $request->get('title');
        $url = $request->get('url');
        $image = $request->get('image');
        $file_flash = $request->file('file_flash');

        $type = $request->get('type');
        if (isset($request['activeValue2'])) {
            $opin = 1;
        } else {
            $opin = 0;
        }
        $rules = [
            'title' => 'required',
            // 'url' => 'required|url',
            'course_id' => 'required',
            'file_flash' => 'required',

        ];

        $messages = [
            'title.required' => 'العنوان مطلوب',
            // 'url.required' => 'رابط الفيديو مطلوب',
            // 'url.url' => 'الرجاء التأكد من رابط الفيديو',
            'course_id.required' => 'الدورة مطلوبة',
            'file_flash.required' => 'الصورة مطلوبة',

        ];

        $validator = \Validator::make(
            [
                'title' => $title,
                // 'url' => $url,
                'course_id' => $course_id,
                'file_flash' => $file_flash,

            ],
            $rules,
            $messages
        );

        if ($validator->fails()) {
            $all = collect($validator->errors()->getMessages())->map(function ($item) {
                return $item[0];
            });
            $strs = [];
            foreach ($all as $value) {
                $strs[] =  $value;
            }
            return response()->json(['status' => false, 'data' => implode(',', $strs)]);
        }
        // if ($type == 3) {
        //     $rules = [
        //         'file_flash' => 'required',

        //     ];

        //     $messages = [
        //         'file_flash.required' => ' ملف فلاش مطلوب',

        //     ];

        //     $validator = \Validator::make(
        //         [
        //             'file_flash' => $file_flash,

        //         ],
        //         $rules,
        //         $messages
        //     );

        //     if ($validator->fails()) {
        //         $all = collect($validator->errors()->getMessages())->map(function ($item) {
        //             return $item[0];
        //         });
        //         $strs = [];
        //         foreach ($all as $value) {
        //             $strs[] =  $value;
        //         }
        //         return response()->json(['status' => false, 'data' => implode(',', $strs)]);
        //     }
        // } else {
        //     $rules = [
        //         'url' => 'required|url',

        //     ];

        //     $messages = [
        //         'url.required' => 'الرابط  مطلوب',
        //         'url.url' => 'الرجاء التأكد من الرابط',

        //     ];

        //     $validator = \Validator::make(
        //         [
        //             'url' => $url,

        //         ],
        //         $rules,
        //         $messages
        //     );

        //     if ($validator->fails()) {
        //         $all = collect($validator->errors()->getMessages())->map(function ($item) {
        //             return $item[0];
        //         });
        //         $strs = [];
        //         foreach ($all as $value) {
        //             $strs[] =  $value;
        //         }
        //         return response()->json(['status' => false, 'data' => implode(',', $strs)]);
        //     }
        // }

        $course = MyModel::find($course_id);
        if (!$course) {
            return response()->json(['status' => false, 'data' => 'الدورة غير موجودة']);
        }


        $user_id = \Auth::user()->id;

        $video = new Video();
        $video->user_id = $user_id;
        $video->title = $title;
        $video->url = $url;
        $video->course_id = $course_id;
        $video->image = $image;
        $video->type = $type;
        $video->opin = $opin;
        $saved = $video->save();
        $max = $video->id;
        $myfile = '';
        if ($request->hasFile('file_flash') && $file_flash->isValid()) {
        $attachment_file_name = static::upload($request, 'file_flash', $request->project_id)['name'];

            // $ext = $file_flash->getClientOriginalExtension();
            // if ($ext != 'zip') {
            //     return response()->json(['status' => false, 'data' => 'يجب أن تكون صيغة الملف .zip']);
            // }
            // $myfile = 'flip_' . strtotime(date("Y-m-d H:i:s")) . $max;
            // $zip = new ZipArchive;
            // $res = $zip->open($file_flash);
            // if ($res === TRUE) {
            //     $zip->extractTo('uploads/' . $myfile);
            //     $zip->close();
            // } else {
            //     return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الرفع']);
            // }
        }

        $video->url = $attachment_file_name;
        $saved = $video->save();

        if (!$saved) {
            return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
        }
        return response()->json(['status' => true, 'data' => 'تمت عملية الإضافة']);
    }
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function deleteVideo(Request $request)
    {
        $id = $request->get('id');
        $item = Video::find($id);
        if ($item != '') {
            $deleted = $item->delete();
            if (!$deleted) {
                return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
            }
            return response()->json(['status' => true, 'data' => 'تم الحذف بنجاح']);
        } else {
            return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
        }
    }
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    public function showfavorite(Request $request)
    {
        $id  = $request->get('id');
        $clint = new MyModel;
        // $data['clints']=$clint->getname($id);
        $data['favorites'] = MyCourses::leftJoin('clients as c', 'my_courses.client_id', '=', 'c.id')
            ->where('my_courses.courses_id', $id)
            ->leftJoin('system_constants as s', function ($join) {
                $join->on('s.value', '=', 'c.governorate')->where('s.type', 'governorate')->whereNull('s.deleted_at');
            })
            ->leftJoin('system_constants as sy', function ($join) {
                $join->on('sy.value', '=', 'c.city')->where('sy.type', 'city')->whereNull('sy.deleted_at');
            })
            ->leftJoin('system_constants as sys', function ($join) {
                $join->on('sys.value', '=', 'c.Degree')->where('sys.type', 'Degree')->whereNull('sys.deleted_at');
            })
            ->select(
                "my_courses.stars_no",
                "c.name as name",
                "c.email as email",
                "c.mobile as mobile",
                "s.name_ar as name_governorate",
                "sy.name_ar as name_city",
                "sys.name_ar as name_Degree"
            )
            ->get();

        $view = view('admin.courses.table-favorite', compact('data'))->render();

        return response()->json(['status' => true, 'data' => $view]);
    }
    public function getTrainers(Request $request)
    {

        $id  = $request->get('id');
        $select = '';
        $select = '<option value=""> اختر مدرب </option>';
        if ($id != '') {
            $data['Trainers'] = Trainers::where('status', 1)->where('universities', $id)->orderBy('id', 'desc')->get();
            if ($data['Trainers'] and count($data['Trainers']) > 0) {
                foreach ($data['Trainers'] as $category) {
                    $select .= '<option value="' . $category->id . '">' . $category->title_ar . '</option>';
                }
            }
        }
        return response()->json(['status' => true, 'data' => $select]);
    }


    public function print_xls($id)
    {

        $data['setting'] = Setting::where('id', 1)->first();

        $item = MyModel::find($id);

        $data['order'] = MyCourses::leftJoin('clients as c', 'my_courses.client_id', '=', 'c.id')
            ->where('my_courses.courses_id', $id)
            ->leftJoin('system_constants as s', function ($join) {
                $join->on('s.value', '=', 'c.governorate')->where('s.type', 'governorate')->whereNull('s.deleted_at');
            })
            ->leftJoin('system_constants as sy', function ($join) {
                $join->on('sy.value', '=', 'c.city')->where('sy.type', 'city')->whereNull('sy.deleted_at');
            })
            ->leftJoin('system_constants as sys', function ($join) {
                $join->on('sys.value', '=', 'c.Degree')->where('sys.type', 'Degree')->whereNull('sys.deleted_at');
            })
            ->select("c.name as name", 'c.email as email', 'c.mobile as mobile', "s.name_ar as name_governorate", "sy.name_ar as name_city", "sys.name_ar as name_Degree")
            ->get();



        $table = '<table border="1" width="100%">
                    <tr>
                        <th  style="text-align:center;font-weight:bold;font-size:13px" colspan="7"> 
                        ' . $item->title . '
                        </th>
                    </tr>
                    <tr>
                        <th  style="text-align:center;font-weight:bold;font-size:13px">#</th>
                        <th  style="text-align:center;font-weight:bold;font-size:13px">الاسم	</th>
                        <th  style="text-align:center;font-weight:bold;font-size:13px">البريد الالكتروني	 </th>
                        <th  style="text-align:center;font-weight:bold;font-size:13px">رقم الجوال	</th>
                        <th  style="text-align:center;font-weight:bold;font-size:13px">الدرجة العلمية</th>
                        <th  style="text-align:center;font-weight:bold;font-size:13px">التقييم</th>

                    </tr>';
        if ($data['order']) {



            if (count($data['order']) > 0) {
                foreach ($data['order'] as $items) {
                    $table .= '<tr>
                                        <td style="text-align:center;font-size:11px">A</td>
                                        <td style="text-align:center;font-size:11px"> ' . $items->name . '</td>
                                        <td style="text-align:center;font-size:11px"> ' . $items->email . '</td>
                                        <td style="text-align:center;font-size:11px"> ' . $items->mobile . '</td>

                                        <td style="text-align:center;font-size:11px"> ' . $items->name_Degree . '</td>
                                        <td style="text-align:center;font-size:11px"> ---</td>


                                    </tr>';
                }
            }
        }
        $table .= '</table>';



        @ob_start();
        echo  chr(239) . chr(187) . chr(191);
        echo $table;
        $filename = 'مسجلين_دورة_' . $item->title . '_' . date('Y-m-d');
        header("Content-Type: application/xls");
        header("Content-Disposition: attachment; filename=" . $filename . ".xls");
        header("Pragma: no-cache");
        header("Expires: 0");
    }

    // 
    /***********************************************************************************************************************/

    public function UpdateOpin(Request $request)
    {
        $id = $request->get('id');
        $item = Video::find($id);

        if ($item != '') {
            if ($item->opin == 0) {
                $item->opin = 1;
            } else {
                $item->opin = 0;
            }
            $saved = $item->save();
            if (!$saved) {
                return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
            }
            return response()->json(['status' => true, 'data' => 'تم تعديل الحالة', 'item' => $item]);
        } else {
            return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
        }
    }

    public function UpdateRating(Request $request)
    {
        $id = $request->get('id');
        $item = MyModel::find($id);

        if ($item != '') {
            if ($item->rating == 0) {
                $item->rating = 1;
            } else {
                $item->rating = 0;
            }
            $saved = $item->save();
            if (!$saved) {
                return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
            }
            return response()->json(['status' => true, 'data' => 'تم تعديل الحالة', 'item' => $item]);
        } else {
            return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
        }
    }
    
        private static function getOrCreateFolder($name, $parent, $service)
    {
        $ret = '';
        $response = $service->files->listFiles([
            'q' => "'$parent' in parents and name = '$name' and trashed=false",
        ]);
        if ($response->files) {
            $ret = $response->files[0];
        } else {
            $fileMetadata = new \Google_Service_Drive_DriveFile([
                'name'     => $name,
                'mimeType' => 'application/vnd.google-apps.folder',
                'parents' => [$parent]
            ]);
            $ret = $service->files->create($fileMetadata, ['fields' => 'id']);
        }
        return $ret;
    }


    static function getOrCreateMonthDir(\Google_Service_Drive $service)
    {
        // $s = Settings::getSettingsByName(['drive_folder_id']);
        $s['drive_folder_id'] = "1p_wMIkdDZGq4D3Rwegjo2vGiYVh4hmb_";
        $y = date('Y');
        $m = date('m');

        $month_folder_id = Cache::get('dfm_' . $y . '_' . $m);

        if (!$month_folder_id) {

            $year_folder_id = Cache::get('dfy_' . $y);
            if (!$year_folder_id) {
                $year_folder = static::getOrCreateFolder($y, $s['drive_folder_id'], $service);

                Cache::forever('dfy_' . $y, $year_folder->id);
                $year_folder_id = $year_folder->id;
            }

            $month_folder = static::getOrCreateFolder($m, $year_folder_id, $service);
            Cache::forever('dfm_' . $y . '_' . $m, $month_folder->id);
            $month_folder_id = $month_folder->id;
        }
        return $month_folder_id;
    }

    static function upload(Request $request, $fileName, $project_id = null, $extension = null, $user_id = null, $new_name = null)
    {
        // $s = Settings::getSettingsByName(['drive_client_id','drive_client_secret','drive_refresh_token','drive_folder_id']);
        $s['drive_client_id'] = "627451534162-rbh206jqut5tf07bi7j8to3ck6p9dbhf.apps.googleusercontent.com";
        $s['drive_client_secret'] = "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";
        $s['drive_refresh_token'] = "1//04Jz3wyC6iMMjCgYIARAAGAQSNwF-L9IrV1c3Mwnl1HKii6YOICBYzJlsiZE59EkPjxwwhw3CwRfM2MLrocOLRHvnweMCsj5kW1M";
        $client = new \Google_Client();
        $ClientId = $s['drive_client_id'];
        $ClientSecret = $s['drive_client_secret'];
        $refreshToken = $s['drive_refresh_token'];
        $client->setClientId($ClientId);
        $client->setClientSecret($ClientSecret);
        $client->refreshToken($refreshToken);
        $client->setAccessType('offline');
        $client->setApprovalPrompt('force');
        // $client->setRedirectUri($this->redirectUri);
        // $client->setAccessType('offline');
        // $client->setApprovalPrompt('force');
        $service = new \Google_Service_Drive($client);

        $dir = static::getOrCreateMonthDir($service);

        $file = $request->file($fileName);
        $ret = '';
        if ($request->hasFile($fileName)) {
            $nameWithExt = $file->getClientOriginalName();
            $name = pathinfo($nameWithExt, PATHINFO_FILENAME);
            $file_mime_type = $file->getClientMimeType();
            $size = $file->getSize();
            $ext = $extension ?? $file->getClientOriginalExtension();
            // $file->move($filePath, $ret);
            // Storage::disk('google')->put($dir.'/'.$ret,file_get_contents($file));

            $fileMetadata = new \Google_Service_Drive_DriveFile([
                'name'     => ($name == 'blob' ? (static::randomString(4) . time()) : ($new_name ?? $name)) . '.' . $ext,
                'mimeType' => $file_mime_type,
                'parents' => [$dir],
                'uploadType' => 'media'
            ]);
            $drive_file = $service->files->create($fileMetadata, ['data' => file_get_contents($file), 'fields' => 'id']);
            $file_name = $file->getClientOriginalName();
            return [
                'name' => \Storage::disk('google')->url($drive_file->id),
                'mime_type' => $file_mime_type,
                'size' => 0,
                'original_name' => $file_name,
            ];
        }
    }

    static function randomString($length)
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyz';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

    static function deleteFile($file_id)
    {
        \Storage::disk('google')->delete($file_id);
    }

    public static function getFileId($url)
    {
        return substr($url, 31, 33);
    }
}
