
@extends('site.layout.layout')
@section('url'){{URL::to('/')}}/category/{{$data['category']->value}}@stop
@section('title'){{\App\Http\Helpers\Helpers::stringReplace($data['category']->name,3)}}@stop
@section('description'){{\App\Http\Helpers\Helpers::stringReplace($setting->description,3)}}@stop


@section('css')
<style>
    .page_title h1 {
        padding: 123px 0 56px;
    }
    .about_inner {
    /* display: none;    */
    visibility: hidden;
    }
    /* .menu_top {
        min-height: 72px;
    } */
    .newsitem .caption{
        background: #3bb367;

    }
    .newsitem .caption a {
    color: #fff;
    }
    .newsitem .caption:before {
        background: #3bb367;
    }
    .newsitem > a::before {
        background:unset !important;
    }

    .single-blog .blog-img a img {
    
        /*height: 215px;*/
    }
</style>
@endsection
@section('content')
<div class="section page-banner-section" style="background-image: url(/new_site/images/page-banner.jpg);">
    <div class="shape-2"></div>
    <div class="container">
        <div class="page-banner-wrap">
            <div class="row">
                <div class="col-lg-12">
                    <!-- Page Banner Content Start -->
                    <div class="page-banner text-center">
                      
                        <h2 class="title"> {{$data['category']->name}} </h2>
                      
    
                        <ul class="breadcrumb justify-content-center">
                            <li class="breadcrumb-item"><a href="{{URL::to('/')}}"> الرئيسية </a></li>
                            <li class="breadcrumb-item active" aria-current="page">
                                {{$data['category']->name}}
                               </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="section blog-section section-padding" @if( count($data['posts']) > 0)  style="padding-top: 50px;" @endif>
    <div class="container">
        <!-- Blog Grid Wrap Start -->
        <div class="blog-grid-wrap">
            @if( count($data['posts']) > 0) 
            
            <div class="row">
                @foreach ($data['posts'] as $item)

                <div class="col-lg-4 col-md-6">
                    <div class="single-blog">
                        <div class="blog-img">
                            <a href="{{URL::to('/')}}/posts/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}">
                                <img src="{{URL::to('/')}}/img/356x300/{{$item->main_image}}" alt=""></a>
                            <div class="top-meta">
                                <span class="date"><span> {{date('d',strtotime($item->date))}}</span> {{\App\Http\Helpers\Helpers::get_month_name(date('M',strtotime($item->date)))}} </span>
                            </div>
                        </div>
                       

                        <div class="blog-content">
                           
                            <h3 class="title"  style="min-height: 60px;">
                                <a href="{{URL::to('/')}}/posts/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}">
                                    {{\App\Http\Helpers\Helpers::cutText($item->title,80,true)}}
                                </a>
                            </h3>
                            <p>
                                {{\App\Http\Helpers\Helpers::cutText($item->summary,80,true)}}
                           </p>
                        </div>
                        <div class="blog-btn">
                            <a class="blog-btn-link" href="{{URL::to('/')}}/posts/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}"> قراءة المزيد    <i class="fas fa-long-arrow-alt-left"></i></a>
                        </div>
                    </div>
                    <!-- Single Blog End -->
                </div>
                @endforeach
                
            </div>
            
            <div class="techmax-pagination ">
                {!! $data['posts']->render() !!}
               
            </div>
            @else 
            <div class="row">
                <div class="col-lg-12 col-md-12 text-center">
                    <h3 class="title ">
                        
                           لا يوجد ( {{$data['category']->name}} ) لعرضها 
                       
                    </h3>
                </div>
            </div>
            @endif
            <!-- Techmax Pagination Start -->

           
            <!-- Techmax Pagination End -->
        </div>
        <!-- Blog Grid Wrap End -->
    </div>
</div>






@endsection

@section('js')
    
@endsection

