@extends('admin.layout.master_layout')

@section('title')
     {{__('text.control_panel')}} ~ الشركاء  

@endsection
@section('css')
    <style>
        .search_result_order {
            position: absolute;
            left: 12px;
            top: 38px;
            width: 90%;
            display: none;
            background: white;
            border-radius: 4px;
            z-index: 9;
            padding: 0;
            margin: 0;
            border: 1px solid #ccc;
        }
        .search_result_order li {
            list-style: none;
            color: #9a9a9a;
            padding: 12px 10px;
            border-bottom: 1px solid #e8e8e8;
            cursor: hand;
            cursor: pointer;
        }
        .search_result_order li.selected {
            background: #dedbdb96;
        }
        #loading{
            display:none;
        }
        .modal{
            overflow-y: auto;
        }

        @media (min-width: 992px){
            .modal-lg {
                max-width: 1300px;
            }
        }

        .form-control{
            padding: 0.5rem 1.15rem !important;
        }
        .main_label ,.additoin_label{
            overflow: hidden;
        }

        .removable{
        position: relative;
        display: inline-block ;
        }
        .removable .btn-remove {
            position: absolute;
            top: 2px;
            left: 2px;
            z-index: 100;
            border-radius: 50%;
            cursor: pointer;
            display: none;
        }
    </style>
    
@endsection
@section('page-content')

<div class="m-grid__item m-grid__item--fluid  m-grid m-grid--ver-desktop m-grid--desktop m-page__container m-body">
    <div class="m-grid__item m-grid__item--fluid m-wrapper">
        <div class="m-subheader ">



			

            <div class="d-flex align-items-center" style="justify-content: space-between;">

                <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
                    <li class="m-nav__item m-nav__item--home">
                        <a href="#" class="m-nav__link m-nav__link--icon">
                            <i class="m-nav__link-icon la la-home"></i>
                        </a>
                    </li>
                    <li class="m-nav__item">
                        <a href="{{ route('admin.dashboard.view') }}" class="m-nav__link">
                            <span class="m-nav__link-text">الصفحة الرئيسية</span>
                        </a>
                    </li>

                    <li class="m-nav__separator">-</li>
                    <li class="m-nav__item">
                        <a href="/admin/institutions" class="m-nav__link">
                            <span class="m-nav__link-text">الشركاء </span>
                        </a>
                    </li>
                </ul>

                <div class="m-demo__preview  m-demo__preview--btn">
                    @can('add_institutions')
                    <button type="button"  data-toggle="modal" data-target="#add_page" class="btn btn-danger m-btn m-btn--custom btnAddCustomer" style="line-height: 15px;"><i class="fa fa-plus"></i> إضافة شريك</button>
                    @endcan 
                </div>

            </div>


           

        </div>

        <div class="m-content m-content pt-3">


            <div class="">

                <div id="table-container">

                    @include('admin.institutions.table-data')

                </div>

            </div>

        </div>

      

    </div>

</div>


@include('admin.institutions.sub.add')
@include('admin.uploads.upload')

@stop



    @section('js')
        <script>
                $('#activeValue').bootstrapSwitch('state', true, true);

            var generalUrl = "{{ route("admin.institutions.index") }}";

            $(document).ready(() => {




                $('#form-post-add').on('submit', function(e){
                    $('#form-post-add #loading').show();
                    e.preventDefault();
                    var formData = new FormData(this);
                    $('.loader_add_user').css('display', 'initial');
                  
                    var id = $("#form-post-add .hidden").val();
                    if (id == 0) {
                        $.ajax({
                            url: "{{ route("admin.institutions.add") }}",
                            type: "post",
                            cache:false,
                            contentType: false,
                            processData: false,
                            data: formData,
                            success: function (data) {
                                $('#form-post-add #loading').hide();

                                console.log(data)
                                if (data["status"] == true) {
                                    swal({
                                        title: "",
                                        text: data["data"],
                                        type: "success",
                                        showCancelButton: false,
                                        confirmButtonColor: "#DD6B55",
                                        confirmButtonText: "حسنا",
                                        cancelButtonText: "الغاء",
                                        closeOnConfirm: true,
                                        closeOnCancel: true
                                    });
                                    var origin = $(location).attr("origin");
                                    var pathname = $(location).attr("pathname");
                                    var page = $('.pagination .active span').text();
                                    url = origin+pathname+'?page='+page;

                                    getData(url);
                                    clearFeildData();
                                    $("#add_page").modal("hide");
                                } else {
                                    $('#form-post-add #loading').hide();
                                    swal({
                                        title: "",
                                        text: data["data"],
                                        type: "error",
                                        showCancelButton: false,
                                        confirmButtonColor: "#DD6B55",
                                        confirmButtonText: "حسناً",
                                        cancelButtonText: "إلغاء",
                                        closeOnConfirm: true,
                                        closeOnCancel: true
                                    });


                                }
                            }
                        });
                    } else {
                        $.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                            }
                        });
                        $.ajax({
                            url: "{{ route("admin.institutions.update") }}",
                            type: "POST",
                            dataType: "JSON",
                            cache:false,
                            contentType: false,
                            processData: false,
                            data: formData,
                            success: function (data) {
                                $('#form-post-add #loading').hide();
                                if (data["status"] == true) {
                                    swal({
                                        title: "",
                                        text: data["data"],
                                        type: "success",
                                        showCancelButton: false,
                                        confirmButtonColor: "#DD6B55",
                                        confirmButtonText: "حسنا",
                                        cancelButtonText: "الغاء",
                                        closeOnConfirm: true,
                                        closeOnCancel: true
                                    });
                                    var origin = $(location).attr("origin");
                                    var pathname = $(location).attr("pathname");
                                    var page = $('.pagination .active span').text();
                                    url = origin+pathname+'?page='+page;
                                    getData(url);
                                    clearFeildData();
                                    $("#add_page").modal("hide");
                                } else {
                                    swal({
                                        title: "",
                                        text: data["data"],
                                        type: "error",
                                        showCancelButton: false,
                                        confirmButtonColor: "#DD6B55",
                                        confirmButtonText: "حسناً",
                                        cancelButtonText: "إلغاء",
                                        closeOnConfirm: true,
                                        closeOnCancel: true
                                    });


                                }
                            }
                        });
                    }
//	}
                });

                $(document).on('click', '.btnAddCustomer', function (e) {
                    e.preventDefault();
                    clearFeildData();
                    $('#add_page .modal-title').html('إضافة');
                    $("#add_page").modal("show");
                    $('#form-post-add').find('.hidden').val(0);
                    $('#addNewpageForm').find(".image").val('');
                    
                    $('.img_review img').attr('src','/admin/assets/app/media/no_image.jpg');
                    $('#activeValue').bootstrapSwitch('state', true, true);

                });


                $(document).on('click', '.updateDetails', function () {
                    $('#load').show();
                    $('#form-post-add').find('.hidden').val(0);
                    clearFeildData();
                    var id = $(this).data('id');
                    $('#form-post-add .hidden').val(id);
                    $.ajax({
                        url: "{{ route("admin.institutions.edit") }}",
                        type: "get",
                        dataType: "JSON",
                        data: {
                            id: id
                        },
                        success: function(data){
                            // $('#load').hide();

                            if(data['status'] == true){
                                $("#form-post-add .title_ar").val(data['data']['title_ar']);
                                $("#form-post-add .title_en").val(data['data']['title_en']);
                                $('#form-post-add .url').val(data['data']['url']);
                                if(data['data']['status'] == 1){
                                    $('#activeValue').bootstrapSwitch('state', true, true);
                                }else{
                                    $('#activeValue').bootstrapSwitch('state', false, true);
                                }
                                $('#form-post-add .img_review img').attr('src','/uploads/'+data['data']['photo']);
                            }
                        },
                        complete: function () {
                            $('#load').hide();

                            $('#add_page').modal('show');

                        },
                        error: function (jqXHR, textStatus, errorThrown) {
                            swal({title: 'حدث خطأ غير معروف، الرجاء المحاولة فيما بعد', type: "error"});
                        }
                    });

                    $('#add_page .modal-title').html('تعديل بيانات');
                    $('.btn_save_user').html('تعديل');

                });

                $(document).on('click','.delete',function(e){
                    var id = $(this).data('id');
                    Swal.fire({
                        title: 'هل تريد حذف هذا العنصر ؟',
                        text: "",
                        type: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'حسنا',
                        cancelButtonText: "الغاء",
                    }).then((result) => {
                        if (result.value) {
                            $.ajaxSetup({
                                headers: {
                                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                                }
                            });
                            $.ajax({
                                url: "{{ route("admin.institutions.delete") }}",
                                type: "post",
                                dataType: "JSON",
                                data: {
                                    id: id
                                },
                                success: function(data){
                                    if(data['status'] == true){
                                        Swal.fire(
                                            'تم الحذف بنجاح',
                                            '',
                                            'success'
                                        )
                                        var origin = $(location).attr("origin");
                                    var pathname = $(location).attr("pathname");
                                    var page = $('.pagination .active span').text();
                                    url = origin+pathname+'?page='+page;
                                        getData(url);
                                        // window.history.pushState("", "", url);
                                    }else{
                                        swal({
                                            title: "",
                                            text: data["data"],
                                            type: "error",
                                            showCancelButton: false,
                                            confirmButtonColor: "#DD6B55",
                                            confirmButtonText: "حسنا",
                                            cancelButtonText: "الغاء",
                                            closeOnConfirm: true,
                                            closeOnCancel: true
                                        });
                                    }
                                },
                            });
                        }
                    })
                });



                /*************************************************************************************************************************/

                $(document).on("input" , "#searchSection .name_seach" , e => {
                    let $this = $(e.currentTarget);
                    var title = $this.val();
                    if(title.length > 3 || title.length <= 0){
                        
                        getData(generalUrl);
                    }
                });


                $(document).on('click', '#table-container .pagination a',function(event) {
                    event.preventDefault();
                    $('li').removeClass('active');
                    $(this).parent('li').addClass('active');
                    var url = $(this).attr('href');
                    getData(url);
                });


            });


            function getData(url) {
                $('#load').show();
                let name = $("#searchSection .name_seach").val();
                $.ajax({
                    url : url,
                    data:{name:name}
                }).done(function (data) {
                    $("#table-container").empty().html(data);
                    $('#load').hide();
                });
            }

            function clearFeildData() {
                $('#form-post-add').find(".title_ar").val('');
                $('#form-post-add').find(".title_en").val('');
	            $('#form-post-add').find(".image").val('');
                $('#form-post-add').find('.hidden').val(0);
                $('#form-post-add .url').val('');
                $('#activeValue').bootstrapSwitch('state', true, true);
                $('.img_review img').attr('src','/admin/assets/app/media/no_image.jpg');
            }
        </script>




        @endsection
