@extends('admin.layout.master_layout')
@section('title')
   لوحة التحكم
@stop

@section('page-content')

<div class="m-grid__item m-grid__item--fluid  m-grid m-grid--ver-desktop m-grid--desktop m-page__container m-body">
    <div class="m-grid__item m-grid__item--fluid m-wrapper">
        <div class="m-subheader ">



			

            <div class="d-flex align-items-center" style="justify-content: space-between;">

                <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
                    <li class="m-nav__item m-nav__item--home">
                        <a href="#" class="m-nav__link m-nav__link--icon">
                            <i class="m-nav__link-icon la la-home"></i>
                        </a>
                    </li>
                    <li class="m-nav__item">
                        <a href="{{ route('admin.dashboard.view') }}" class="m-nav__link">
                            <span class="m-nav__link-text">الرئيسية</span>
                        </a>
                    </li>

                    <li class="m-nav__separator">-</li>
                    <li class="m-nav__item">
                        <a href="/admin/profile" class="m-nav__link">
                            <span class="m-nav__link-text">{{__('text.profile')}}</span>
                        </a>
                    </li>
                </ul>

               

            </div>


           

        </div>

        <div class="m-content m-content pt-3">

            <div class="m-portlet__body">

                <div>
                    <form class="profileForm" id="profileForm" action="" method="post">
                        @csrf
                            <div class="form-group m-form__group row">
                                <div class="col-md-6 mb-4">
                                    <label>{{__('text.fullname')}} <span class="required">*</span></label>
                                    <div class="form-valid">
                                        <input type="text" disabled value="{{\Auth::user()->fullname}}" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <label>{{__('text.username')}} <span class="required">*</span></label>
                                    <div class="form-valid">
                                        <input type="text" disabled value="{{\Auth::user()->username}}" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <label> {{__('text.email')}}<span class="required">*</span></label>
                                    <div class="form-valid">
                                        <input type="email" disabled  value="{{Auth::user()->email}}" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                     <label>{{__('text.password')}} <span class="required"></span></label>
                                    <div class="form-valid">
                                        <input type="password" name="password" value="" class="form-control password">
                                    </div>
                                </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary btn_save_page">{{__('text.save')}}</button>
                        </div>
                    </form>
                </div>

            </div>

        </div>

      

    </div>

</div>


@include('admin.tags.sub.add')
@stop

@section('js')
<script>
            $('#profileForm').on('submit', function(e){
            e.preventDefault();
            var formData = new FormData(this);
                $.ajax({
                    url: '/admin/password',
                    dataType:'json',
                    type: 'POST',
                    cache:false,
					contentType: false,
					processData: false,
                    data: formData,
                    success: function (data) {
                        if (data["status"] == true) {
                            swal({
                                title: "",
                                text: data["data"],
                                type: "success",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "{{__('text.ok')}}",
                                cancelButtonText: "{{__('text.cancel')}}",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });

                                $('.password').val('');
                        }else {
                            if(data['data_validator']!=null){
                                var dt = '<ul>';
                                 $.each(data["data_validator"], function (key, value) {
                                     dt = dt + '<li>' + value + '</li>';
                                 })
                                 dt =dt+ '</ul>';
                             swal({
                                 title: "",
                                 text: data["data"],
                                 type: "error",
                                 html:dt,
                                 showCancelButton: false,
                                 confirmButtonColor: "#DD6B55",
                                 confirmButtonText: "{{__('text.ok')}}",
                                 cancelButtonText: "{{__('text.cancel')}}",
                                 closeOnConfirm: true,
                                 closeOnCancel: true
                             });



                     }else{

                         swal({
                             title: "",
                             text: data["data"],
                             type: "error",
                             showCancelButton: false,
                             confirmButtonColor: "#DD6B55",
                             confirmButtonText: "{{__('text.ok')}}",
                             cancelButtonText: "{{__('text.cancel')}}",
                             closeOnConfirm: true,
                             closeOnCancel: true
                         });


                     }
                        }
                    },
                });
            });
</script>
@stop
