<?php

namespace App\Models;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Model;

class Tag extends Model
{
    //
    protected $table = 'tags';
    protected $fillable = ['name','user_id','status'];

    public function getTag($name){
        $tags = $this;
        $tags = $tags->leftJoin('users as u', function($join) {
            $join->on('u.id', '=', 'tags.user_id')->whereNull('u.deleted_at');
        });
 
        if($name != ''){
            $tags = $tags->where('name','LIKE','%'.$name.'%');
        }
        return $tags->select('tags.id','tags.name','u.fullname','tags.status')->orderBy('tags.id','desc')->paginate(15);
    }

    public function add_tag($name ,$status){
        $this->name = $name;
        $this->status = $status;
        $this->user_id = \Auth::user()->id;
        $this->save();
        return $this;
    }

    public function add_tagg($serach_tag ,$status){
        $this->name = $serach_tag;
        $this->status = $status;
        $this->user_id = \Auth::user()->id;
        $this->save();
        return $this;
    }

    public function update_tag($name ,$status){

        $this->name = $name;
        $this->status = $status;
        $this->user_id = \Auth::user()->id;
        $this->save();
        return $this;
    }

    public function UpdateStatus($obj){
        if($obj->status == 0){
            $obj->status = 1;
        }else{
            $obj->status = 0;
        }
        return  $obj->save();
    }

    public function gettags($id){
        return $this->where('id',$id)->first();
    }

    public function posts(){
        return $this->belongsToMany(Posts::class,'news_tag','tag_id','news_id');
    }
    
    public function user(){
        return $this->belongsTo(User::class,'user_id');
    }
}
