<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Client extends Authenticatable
{
	use Notifiable;
	use SoftDeletes;

	/**
	 * The attributes that are mass assignable.
	 *
	 * @var array
	 */
	protected $fillable = [
		'name', 'email', 'password', 'status',
		'user_id',
	];

	/**
	 * The attributes that should be hidden for arrays.
	 *
	 * @var array
	 */
	protected $hidden = [
		'password', 'remember_token',
	];

	public function get_clients($name, $mobile, $governorate, $city, $Degree)
	{
		$lang = \App::getLocale();
		$clients = $this->OrderBy('clients.id', 'desc')->where('clients.hide', 0)
			->leftJoin('system_constants as s', function ($join) {
				$join->on('s.value', '=', 'clients.governorate')->where('s.type', 'governorate')->whereNull('s.deleted_at');
			})
			->leftJoin('system_constants as sy', function ($join) {
				$join->on('sy.value', '=', 'clients.city')->where('sy.type', 'city')->whereNull('sy.deleted_at');
			})
			->leftJoin('system_constants as sys', function ($join) {
				$join->on('sys.value', '=', 'clients.Degree')->where('sys.type', 'Degree')->whereNull('sys.deleted_at');
			});
		if ($name != '') {
			$clients =  $clients->where('clients.name', 'like', '%' .  $name . '%')->orWhere('clients.email', 'like', '%' .  $name . '%');
		}
		if ($mobile != '') {
			$clients =  $clients->where('clients.mobile', 'like', '%' .  $mobile . '%');
		}
		if ($governorate != '') {
			$clients =  $clients->where('clients.governorate', $governorate);
		}
		if ($city != '') {
			$clients =  $clients->where('clients.city', $city);
		}
		if ($Degree != '') {
			$clients =  $clients->where('clients.Degree', $Degree);
		}
		// 
		return $clients = $clients->select('clients.*', "s.name_" . $lang . " as name_governorate", "sy.name_" . $lang . " as name_city", "sys.name_" . $lang . " as name_Degree")->paginate(15);
	}

	public function get_client($id)
	{
		return $this->find($id);
	}

	public function add_client($name, $email, $password, $status = 1, $mobile, $state_key)
	{
		$this->name			=	$name;
		$this->email		=	$email;
		$this->password		=	\Hash::make($password);
		$this->mobile		=	$mobile;
		$this->status		=	$status;
		$this->state_key	=	$state_key;

		$this->save();

		return $this;
	}

	public function update_client($obj, $name, $email, $password = '', $status, $mobile, $state_key)
	{
		$obj->name			=	$name;
		$obj->email			=	$email;
		$obj->mobile			=	$mobile;
		if ($password != '') {
			$obj->password		=	\Hash::make($password);
		}
		$obj->status		=	$status;
		$obj->state_key	    =	$state_key;
		return $obj->save();
	}

	public function update_status($obj)
	{
		if ($obj->status == 0) {
			$obj->status	=	1;
		} else {
			$obj->status	=	0;
		}
		return $obj->save();
	}

	public function delete_client($obj)
	{
		return $obj->delete();
	}

	public function change_password($obj, $password)
	{
		$obj->password = \Hash::make($password);
		return $obj->save();
	}
}
