<?php

namespace App\Http\Controllers\Site;

use App\Models\User;
use App\Models\static_page;
use App\Models\Posts;
use App\Models\Tag;
use App\Models\PostsHome;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;
use App\Models\Messages;
use App\Models\Albums;
use App\Models\Setting;
use Carbon\Carbon;
use App\Mail\ContactUs;
use App\Mail\SendCod;
use App\Models\Aboutus;
use App\Models\AlbumsImages;
use App\Models\Business;
use App\Models\Client;
use App\Models\Course;
use App\Models\Donation;
use App\Models\Favorites;
use App\Models\HowWork;
use App\Models\MyCourses;
use App\Models\Order;
use App\Models\OurClients;
use App\Models\Participation;
use App\Models\Plan;
use App\Models\RealEstate;
use App\Models\Service;
use App\Models\Slider;
use App\Models\StaticPage;
use App\Models\System_Constants;
use App\Models\Tmp;
use App\Models\Trainers;
use App\Models\Universities;
use App\Models\Video;
use Facade\FlareClient\Http\Response;
use Illuminate\Support\Facades\Storage;

class ProfileController extends BaseController
{
    public function __construct()
    {
        parent::__construct();
    }



    public function index($lang = "ar")
    {
        if (!in_array($lang, ['ar', 'en'])) {
            abort(404);
        }

        \Session::put('locale', $lang);
        \App::setLocale(\Session::get('locale') ? \Session::get('locale') : $lang);
        $lang            =    \Session::get('locale') ? \Session::get('locale') : \App::getLocale();
        $lang_val        =    ['ar' => 1, 'en' => 2];

        $client = Auth::guard('clients')->user();
        if ($client == '') {
            abort(404);
        }
        $data['clients'] = Client::where('clients.id', $client->id)
            ->leftJoin('system_constants as s', function ($join) {
                $join->on('s.value', '=', 'clients.governorate')->where('s.type', 'governorate')->whereNull('s.deleted_at');
            })
            ->leftJoin('system_constants as sy', function ($join) {
                $join->on('sy.value', '=', 'clients.city')->where('sy.type', 'city')->whereNull('sy.deleted_at');
            })
            ->leftJoin('system_constants as sys', function ($join) {
                $join->on('sys.value', '=', 'clients.Degree')->where('sys.type', 'Degree')->whereNull('sys.deleted_at');
            })
            ->select('clients.*', "s.name_" . $lang . " as name_governorate", "sy.name_" . $lang . " as name_city", "sys.name_" . $lang . " as name_Degree")
            ->first();

        $data['favorites'] = MyCourses::leftJoin('courses as t', 'my_courses.courses_id', '=', 't.id')
            ->where('my_courses.client_id', $client->id)->where('my_courses.deleted_at', null)
            ->orderBy('my_courses.id', 'desc')
            ->get(['t.id', "t.title as name", "t.image as img", 't.price', 't.rating', 'my_courses.stars_no','t.status']);

        $data['donation'] = Donation::where('donation.client_id', $client->id)
            ->leftJoin('my_courses as mc', function ($join) {
                $join->on('mc.id', '=', 'donation.order_id')->whereNull('mc.deleted_at');
            })
            ->leftJoin('courses as c', function ($join) {
                $join->on('mc.courses_id', '=', 'c.id')->whereNull('mc.deleted_at');
            })
            ->select('donation.*', "c.title as name")
            ->get();

        $system = new System_Constants();
        $data['Degree'] = $system->constants('Degree');


        $setting = \App\Models\Setting::where('id', 1)->first(["name_" . $lang . " as name", "description_" . $lang . " as description"]);
        return view('site.profile', compact(['data', 'setting']));
    }

    public function profile_trainers($lang = "ar")
    {
        if (!in_array($lang, ['ar', 'en'])) {
            abort(404);
        }

        \Session::put('locale', $lang);
        \App::setLocale(\Session::get('locale') ? \Session::get('locale') : $lang);
        $lang            =    \Session::get('locale') ? \Session::get('locale') : \App::getLocale();
        $lang_val        =    ['ar' => 1, 'en' => 2];

        $client = Auth::guard('trainers')->user();
        if ($client == '') {
            abort(404);
        }
        $data['clients'] = Trainers::where('trainers.id', $client->id)
            ->leftJoin('universities as u', function ($join) {
                $join->on('u.id', '=', 'trainers.universities')->whereNull('u.deleted_at');
            })
            ->select('trainers.*', 'u.title_ar as name_universities')->first();

        $data['courses'] = Course::where('courses.trainers', $client->id)->select('courses.*')->orderBy('id', 'desc')->get();

        $system = new System_Constants();
        $data['Degree'] = $system->constants('Degree');
        $data['courses_category'] = $system->constants('courses_category');
        $data['universities'] = Universities::orderBy('id', 'desc')->get();





        $setting = \App\Models\Setting::where('id', 1)->first(["name_" . $lang . " as name", "description_" . $lang . " as description"]);
        return view('site.profile_trainers', compact(['data', 'setting']));
    }

    public function edit_profile($lang = "ar", Request $request)
    {

        if (!in_array($lang, ['ar', 'en'])) {
            abort(404);
        }

        \Session::put('locale', $lang);
        \App::setLocale(\Session::get('locale') ? \Session::get('locale') : $lang);
        $lang            =    \Session::get('locale') ? \Session::get('locale') : \App::getLocale();
        $lang_val        =    ['ar' => 1, 'en' => 2];

        $id = $request->get('id');
        $item = Client::find(\Auth::guard('clients')->user()->id);

        $item_city = System_Constants::where('system_constants.type', 'city')
            ->where('system_constants.status', 1)
            ->where('system_constants.value3', $item->governorate)
            ->select('value as id', "name_$lang as name", "type", "photo as image", 'value3')
            ->get();
        $options = '';
        $options .= '<option value=""> ' . trans('app.city') . '</option>';
        foreach ($item_city as $constant) {
            $options .= '<option value="' . $constant->id . '">' . $constant->name . '</option>';
        }


        if ($item != '') {
            return response()->json(['status' => true, 'data' => $item, 'options' => $options]);
        } else {
            return response()->json(['status' => false, 'data' => trans("lang.error")]);
        }
    }
    public function edit_profile_trainers($lang = "ar", Request $request)
    {

        if (!in_array($lang, ['ar', 'en'])) {
            abort(404);
        }

        \Session::put('locale', $lang);
        \App::setLocale(\Session::get('locale') ? \Session::get('locale') : $lang);
        $lang            =    \Session::get('locale') ? \Session::get('locale') : \App::getLocale();
        $lang_val        =    ['ar' => 1, 'en' => 2];

        $id = $request->get('id');
        $item = Trainers::find(\Auth::guard('trainers')->user()->id);

        if ($item != '') {
            return response()->json(['status' => true, 'data' => $item]);
        } else {
            return response()->json(['status' => false, 'data' => trans("lang.error")]);
        }
    }
    public function edit_courses($lang = "ar", Request $request)
    {

        if (!in_array($lang, ['ar', 'en'])) {
            abort(404);
        }

        \Session::put('locale', $lang);
        \App::setLocale(\Session::get('locale') ? \Session::get('locale') : $lang);
        $lang            =    \Session::get('locale') ? \Session::get('locale') : \App::getLocale();
        $lang_val        =    ['ar' => 1, 'en' => 2];

        $id = $request->get('id');
        $item = Trainers::find(\Auth::guard('trainers')->user()->id);
        $item = Course::where('id', $id)->orderBy('id', 'desc')->first();

        if ($item != '') {
            return response()->json(['status' => true, 'data' => $item]);
        } else {
            return response()->json(['status' => false, 'data' => trans("lang.error")]);
        }
    }

    public function update_profile($lang = "ar", Request $request)
    {

        if (!in_array($lang, ['ar', 'en'])) {
            abort(404);
        }

        \Session::put('locale', $lang);
        \App::setLocale(\Session::get('locale') ? \Session::get('locale') : $lang);
        $lang            =    \Session::get('locale') ? \Session::get('locale') : \App::getLocale();
        $lang_val        =    ['ar' => 1, 'en' => 2];


        $user = session('user', []);
        $users = array_keys($user);

        $client = (Auth::guard('clients')->user()->id);

        if ($user == []) {
            $data['client'] = Client::where('id', \Auth::guard('clients')->user()->id)->first();
            $email = $request->get('email');
            $mobile = $request->get('mobile');
            $password = $request->get('password');
            $about = $request->get('about');
            $name = $request->get('name');
            $State_Key = $request->get('State_Key');

            $gender = $request->get('gender');
            $dob = $request->get('dob');


            $governorate = $request->get('governorate');
            $city = $request->get('city');
            $title = $request->get('title');


            $Degree = $request->get('Degree');
            $Specialization = $request->get('Specialization');


            $file = $request->file('photo');
            if ($mobile) {
                $rules = [
                    'mobile' => 'numeric|digits:10',
                ];
                // $messages = [
                //     // 'mobile.min' => trans('lang.mobile_min'),
                //     'mobile.numeric' => trans('lang.mobile_min'),

                // ];
                $validator = \Validator::make(
                    [
                        'mobile' => $mobile,
                    ],
                    $rules

                );
                if ($validator->fails()) {
                    return response()->json(['status' => false, 'data' => trans('lang.mobile_min')]);
                    // return response()->json(['status' => false, 'data_validator' => $validator->messages() ]);
                }
            }


            if ($email != '') {
                $users_count = Client::where('email', $email)->where('id', '!=', $data['client']->id)->count();
                if ($users_count > 0) {
                    return response()->json(['status' => false, 'data' => ' البريد الإلكتروني مستخدم من قبل']);
                }
            }

            if ($mobile != '') {
                $users_count = Client::where('mobile', $mobile)->where('id', '!=',  $data['client']->id)->count();
                if ($users_count > 0) {
                    return response()->json(['status' => false, 'data' => 'رقم الجوال مستخدم من قبل']);
                }
            }
            if ($email != '') {
                $users_count = Trainers::where('email', $email)->count();
                if ($users_count > 0) {
                    return response()->json(['status' => false, 'data' => ' البريد الإلكتروني مستخدم من قبل']);
                }
            }

            if ($mobile != '') {
                $users_count = Trainers::where('mobile', $mobile)->count();
                if ($users_count > 0) {
                    return response()->json(['status' => false, 'data' => 'رقم الجوال مستخدم من قبل']);
                }
            }

            $image = '';
            if ($request->hasFile('photo') && $file->isValid()) {
                $image = 'profile_' . $client . strtotime(date("Y-m-d H:i:s")) . '.' . $file->getClientOriginalExtension();
                $file->move(public_path('uploads'), $image);
            }


            \DB::beginTransaction();
            try {

                if ($name) {
                    $data['client']->name = $name;
                }
                if ($email) {
                    $data['client']->email = $email;
                }
                if ($password) {
                    $data['client']->password = \Hash::make($password);
                }
                if ($mobile) {
                    $data['client']->mobile = $mobile;
                }
                if ($State_Key) {
                }
                if ($image) {
                    $data['client']->img = $image;
                }

                if ($gender) {
                    $data['client']->gender = $gender;
                }
                if ($dob) {
                    $data['client']->dob = $dob;
                }
                if ($governorate) {
                    $data['client']->governorate = $governorate;
                }
                if ($city) {
                    $data['client']->city = $city;
                }
                if ($title) {
                    $data['client']->title = $title;
                }
                if ($Degree) {
                    $data['client']->Degree = $Degree;
                }
                if ($Specialization) {
                    $data['client']->Specialization = $Specialization;
                }

                $saved = $data['client']->save();
                if (!$saved) {
                    return response()->json(['status' => false, 'data' => trans('lang.error')]);
                }

                $data['client'] = Client::where('clients.id', \Auth::guard('clients')->user()->id)
                    ->leftJoin('system_constants as sys', function ($join) {
                        $join->on('sys.value', '=', 'clients.Degree')->where('sys.type', 'Degree')->whereNull('sys.deleted_at');
                    })
                    ->select('clients.*', "sys.name_" . $lang . " as name_Degree")

                    ->first();

                \DB::commit();
                return response()->json(['status' => true, 'data' => trans('lang.success'), 'client' => $data['client']]);
            } catch (\Exception $e) {
                \DB::rollback();
                return response()->json(['status' => false, 'data' => trans('lang.error'), 'e' => $e->getMessage()]);
            }
        } else {
            return redirect("/");
        }
    }

    public function update_profile_trainers($lang = "ar", Request $request)
    {

        if (!in_array($lang, ['ar', 'en'])) {
            abort(404);
        }

        \Session::put('locale', $lang);
        \App::setLocale(\Session::get('locale') ? \Session::get('locale') : $lang);
        $lang            =    \Session::get('locale') ? \Session::get('locale') : \App::getLocale();
        $lang_val        =    ['ar' => 1, 'en' => 2];


        $user = session('user', []);
        $users = array_keys($user);

        $client = (Auth::guard('trainers')->user()->id);

        if ($user == []) {
            $data['client'] = Trainers::where('id', \Auth::guard('trainers')->user()->id)->first();
            $email = $request->get('email');
            $mobile = $request->get('mobile');
            $password = $request->get('password');
            $note = $request->get('note');
            $name = $request->get('name');

            $dob = $request->get('dob');


            $governorate = $request->get('governorate');
            $city = $request->get('city');
            $title = $request->get('title');


            $Degree = $request->get('Degree');
            $Specialization = $request->get('Specialization');


            $file = $request->file('photo');



            if ($email != '') {
                $users_count = Trainers::where('email', $email)->where('id', '!=', $data['client']->id)->count();
                if ($users_count > 0) {
                    return response()->json(['status' => false, 'data' => ' البريد الإلكتروني مستخدم من قبل']);
                }
            }

            if ($mobile != '') {
                $users_count = Trainers::where('mobile', $mobile)->where('id', '!=',  $data['client']->id)->count();
                if ($users_count > 0) {
                    return response()->json(['status' => false, 'data' => 'رقم الجوال مستخدم من قبل']);
                }
            }
            if ($email != '') {
                $users_count = Client::where('email', $email)->count();
                if ($users_count > 0) {
                    return response()->json(['status' => false, 'data' => ' البريد الإلكتروني مستخدم من قبل']);
                }
            }

            if ($mobile != '') {
                $users_count = Client::where('mobile', $mobile)->count();
                if ($users_count > 0) {
                    return response()->json(['status' => false, 'data' => 'رقم الجوال مستخدم من قبل']);
                }
            }

            $image = '';
            if ($request->hasFile('photo') && $file->isValid()) {
                $image = 'profile_' . $client . strtotime(date("Y-m-d H:i:s")) . '.' . $file->getClientOriginalExtension();
                $file->move(public_path('uploads'), $image);
            }


            \DB::beginTransaction();
            try {

                if ($name) {
                    $data['client']->title_ar = $name;
                }
                if ($email) {
                    $data['client']->email = $email;
                }
                if ($password) {
                    $data['client']->password = \Hash::make($password);
                }
                if ($password) {
                    $data['client']->pass = $password;
                }
                if ($mobile) {
                    $data['client']->mobile = $mobile;
                }
                if ($image) {
                    $data['client']->photo = $image;
                }
                if ($dob) {
                    $data['client']->dob = $dob;
                }
                if ($note) {
                    $data['client']->details_ar = $note;
                }

                $saved = $data['client']->save();
                if (!$saved) {
                    return response()->json(['status' => false, 'data' => trans('lang.error')]);
                }


                $data['client'] = Trainers::where('trainers.id', $data['client']->id)
                    ->leftJoin('universities as u', function ($join) {
                        $join->on('u.id', '=', 'trainers.universities')->whereNull('u.deleted_at');
                    })
                    ->select('trainers.*', 'u.title_ar as name_universities')->first();


                \DB::commit();
                return response()->json(['status' => true, 'data' => trans('lang.success'), 'client' => $data['client']]);
            } catch (\Exception $e) {
                \DB::rollback();
                return response()->json(['status' => false, 'data' => trans('lang.error'), 'e' => $e->getMessage()]);
            }
        } else {
            return redirect("/");
        }
    }

    public function getLogout(Request $request)
    {

        \Auth::guard('clients')->logout();
        \Auth::guard('trainers')->logout();

        return redirect()->intended("/");
    }


    public function register_for_the_course(Request $request)
    {
        $cours_id = $request->get('id');
        //  $user=session('user',[]);
        //  $users=array_keys ($user);
        if (Auth::guard('clients')->check()) {
            $client = (Auth::guard('clients')->user()->id);
            if ($client) {
                if ($cours_id) {
                    $favorites = MyCourses::where('courses_id', $cours_id)->where('client_id', $client)->first();
                    if ($favorites) {
                        return response()->json(['status' => true, 'data' => ' تم التسجيل بالدورة  مسبقا ']);
                    } else {
                        \DB::beginTransaction();
                        try {

                            $favorites = new MyCourses();
                            $favorites->client_id = $client;
                            $favorites->courses_id = $cours_id;
                            $favorites->date = date('Y-m-d');
                            $favorites->type = 1;
                            $favorites->status = 0;
                            $saved = $favorites->save();

                            $data['favorites'] = MyCourses::leftJoin('courses as t', 'my_courses.courses_id', '=', 't.id')->where('t.status', 1)
                                ->where('my_courses.client_id', $client)->where('my_courses.deleted_at', null)->orderBy('my_courses.id', 'desc')
                                ->get(['t.id', "t.title as name", "t.image as img", 't.price', 't.rating', 'my_courses.stars_no']);

                            $view = view('site.sub_profile.table-data-Favorite', compact('data'))->render();


                            \DB::commit();
                            return response()->json(['status' => true, 'data' => trans('lang.success')]);
                        } catch (\Exception $e) {
                            \DB::rollback();
                        }
                        return response()->json(['status' => false, 'data' => trans('lang.error'), 'e' => $e->getMessage()]);
                    }
                } else {
                    return response()->json(['status' => false, 'data' => ' حدث خطأ ']);
                }
            } else {
                return response()->json(['status' => false, 'data' => trans('lang.error')]);
            }
        } else {
            return response()->json(['status' => false, 'x' => 1, 'data' => ' عليك تسجيل الدخول ']);
        }
    }
    public function removeCours(Request $request)
    {
        $cours_id = $request->get('id');
        //  $user=session('user',[]);
        //  $users=array_keys ($user);
        if (Auth::guard('clients')->check()) {
            $client = (Auth::guard('clients')->user()->id);
            if ($client) {
                if ($cours_id) {
                    $favorites = MyCourses::where('courses_id', $cours_id)->where('client_id', $client)->first();
                    if ($favorites) {
                        $deleted = $favorites->delete();

                        $data['favorites'] = MyCourses::leftJoin('courses as t', 'my_courses.courses_id', '=', 't.id')->where('t.status', 1)
                            ->where('my_courses.client_id', $client)->where('my_courses.deleted_at', null)->orderBy('my_courses.id', 'desc')
                            ->get(['t.id', "t.title as name", "t.image as img", 't.price', 't.rating', 'my_courses.stars_no']);

                        $view = view('site.sub_profile.table-data-Favorite', compact('data'))->render();

                        return response()->json(['status' => true, 'data' => trans('lang.success'), 'view' => $view]);
                    }
                } else {
                    return response()->json(['status' => false, 'data' => ' حدث خطأ ']);
                }
            } else {
                return response()->json(['status' => false, 'data' => trans('lang.error')]);
            }
        } else {
            return response()->json(['status' => false, 'x' => 1, 'data' => ' عليك تسجيل الدخول ']);
        }
    }


    // 
    public function add_courses(Request $request)
    {
        if (Auth::guard('trainers')->check()) {
            $trainers = Auth::guard('trainers')->user()->id;
            if ($trainers) {
                $data['client'] = Trainers::where('trainers.id', $trainers)
                    ->leftJoin('universities as u', function ($join) {
                        $join->on('u.id', '=', 'trainers.universities')->whereNull('u.deleted_at');
                    })
                    ->select('trainers.*', 'u.title_ar as name_universities')->first();

                $title = $request->get('title');
                $details = $request->get('details');
                $lang = 1;
                $photo = $request->file('photo');
                $category_id = $request->get('category_id');
                $price = $request->get('price');
                $universities = $data['client']->universities;
                $status = 0;


                $rules = [
                    'title' => 'required',
                    'details' => 'required',
                    'lang' => 'required',
                    'category_id' => 'required',
                    'photo' => 'required',
                    'price' => 'required',

                    'universities' => 'required',
                    'trainers' => 'required',

                ];


                $messages = [
                    'title.required' => 'العنوان مطلوب',
                    'details.required' => 'التفاصيل مطلوب',
                    'lang.required' => 'اللغة مطلوبة',
                    'category_id.required' => 'التصنيف مطلوب',
                    'photo.required' => 'الصورة مطلوبة',
                    'price.required' => 'السعر مطلوب',

                    'universities.required' => 'الجامعة مطلوب',
                    'trainers.required' => 'المدرب مطلوب',

                ];

                $validator = \Validator::make(
                    [
                        'title' => $title,
                        'details' => $details,
                        'lang' => $lang,
                        'category_id' => $category_id,
                        'photo' => $photo,
                        'price' => $price,

                        'universities' => $universities,
                        'trainers' => $trainers,

                    ],
                    $rules,
                    $messages
                );

                if ($validator->fails()) {
                    $all = collect($validator->errors()->getMessages())->map(function ($item) {
                        return $item[0];
                    });
                    $strs = [];
                    foreach ($all as $value) {
                        $strs[] =  $value;
                    }
                    return response()->json(['status' => false, 'data' => implode(',', $strs)]);
                }

                if ($price <= 0) {
                    return response()->json(['status' => false, 'data' => 'السعر الدورة أكبر من صفر']);
                }
                $add_image = '';
                if ($request->hasFile('photo') && $photo->isValid()) {
                    $add_image = 'course_' . strtotime(date("Y-m-d H:i:s")) . '.' . $photo->getClientOriginalExtension();
                    $photo->move(public_path('uploads'), $add_image);
                }
                // client_id
                $item = new Course();
                $item->user_id = -1;
                $item->title = $title;
                $item->details = $details;
                $item->lang = $lang;
                $item->category_id = $category_id;
                $item->status = $status;
                $item->image = $add_image;
                $item->price = $price;

                $item->universities = $universities;
                $item->trainers = $trainers;

                $saved = $item->save();


                $data['courses'] = Course::where('trainers', $trainers)->orderBy('id', 'desc')->get();

                $view = view('site.sub_profile.table-data-course', compact('data'))->render();

                if (!$saved) {
                    return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
                }
                return response()->json(['status' => true, 'view' => $view, 'data' => 'تمت عملية الإضافة']);
            }
        }
    }
    public function update_courses(Request $request)
    {
        if (Auth::guard('trainers')->check()) {
            $trainers = Auth::guard('trainers')->user()->id;
            if ($trainers) {
                $data['client'] = Trainers::where('trainers.id', $trainers)
                    ->leftJoin('universities as u', function ($join) {
                        $join->on('u.id', '=', 'trainers.universities')->whereNull('u.deleted_at');
                    })
                    ->select('trainers.*', 'u.title_ar as name_universities')->first();
                $id = $request->get('id');
                $title = $request->get('title');
                $details = $request->get('details');
                $lang = 1;
                $photo = $request->file('photo');
                $category_id = $request->get('category_id');
                $price = $request->get('price');
                $universities = $data['client']->universities;
                $status = 0;


                $rules = [
                    'title' => 'required',
                    'details' => 'required',
                    'lang' => 'required',
                    'category_id' => 'required',
                    // 'photo' => 'required',
                    'price' => 'required',

                    'universities' => 'required',
                    'trainers' => 'required',

                ];


                $messages = [
                    'title.required' => 'العنوان مطلوب',
                    'details.required' => 'التفاصيل مطلوب',
                    'lang.required' => 'اللغة مطلوبة',
                    'category_id.required' => 'التصنيف مطلوب',
                    // 'photo.required' => 'الصورة مطلوبة',
                    'price.required' => 'السعر مطلوب',

                    'universities.required' => 'الجامعة مطلوب',
                    'trainers.required' => 'المدرب مطلوب',

                ];

                $validator = \Validator::make(
                    [
                        'title' => $title,
                        'details' => $details,
                        'lang' => $lang,
                        'category_id' => $category_id,
                        // 'photo' => $photo,
                        'price' => $price,

                        'universities' => $universities,
                        'trainers' => $trainers,

                    ],
                    $rules,
                    $messages
                );

                if ($validator->fails()) {
                    $all = collect($validator->errors()->getMessages())->map(function ($item) {
                        return $item[0];
                    });
                    $strs = [];
                    foreach ($all as $value) {
                        $strs[] =  $value;
                    }
                    return response()->json(['status' => false, 'data' => implode(',', $strs)]);
                }

                if ($price <= 0) {
                    return response()->json(['status' => false, 'data' => 'السعر الدورة أكبر من صفر']);
                }
                $add_image = '';
                if ($request->hasFile('photo') && $photo->isValid()) {
                    $add_image = 'course_' . strtotime(date("Y-m-d H:i:s")) . '.' . $photo->getClientOriginalExtension();
                    $photo->move(public_path('uploads'), $add_image);
                }
                // client_id
                $item = Course::where('id', $id)->first();
                $item->title = $title;
                $item->details = $details;
                $item->lang = $lang;
                $item->category_id = $category_id;
                $item->status = $status;
                if ($add_image) {
                    $item->image = $add_image;
                }
                $item->price = $price;
                $saved = $item->save();

                $data['courses'] = Course::where('trainers', $trainers)->orderBy('id', 'desc')->get();

                $view = view('site.sub_profile.table-data-course', compact('data'))->render();

                if (!$saved) {
                    return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
                }
                return response()->json(['status' => true, 'view' => $view, 'data' => 'تمت عملية الإضافة']);
            }
        }
    }

    // 
    public function showRegisteredCours($lang = "ar", Request $request)
    {

        if (!in_array($lang, ['ar', 'en'])) {
            abort(404);
        }

        \Session::put('locale', $lang);
        \App::setLocale(\Session::get('locale') ? \Session::get('locale') : $lang);
        $lang            =    \Session::get('locale') ? \Session::get('locale') : \App::getLocale();
        $lang_val        =    ['ar' => 1, 'en' => 2];
        if (Auth::guard('trainers')->check()) {
            $trainers = Auth::guard('trainers')->user()->id;
            if ($trainers) {

                $id = $request->get('id');
                $item = Trainers::find(\Auth::guard('trainers')->user()->id);

                $data['favorites'] = MyCourses::leftJoin('clients as c', 'my_courses.client_id', '=', 'c.id')
                    ->where('my_courses.courses_id', $id)
                    ->leftJoin('system_constants as sys', function ($join) {
                        $join->on('sys.value', '=', 'c.Degree')->where('sys.type', 'Degree')->whereNull('sys.deleted_at');
                    })
                    ->select("c.name as name", 'c.email as email', 'c.mobile as mobile', "sys.name_ar as name_Degree", 'my_courses.stars_no')
                    ->get();

                // $view = view('admin.courses.table-favorite', compact('data'))->render();
                $view = view('site.sub_profile.table-data-course-registered', compact('data'))->render();

                if ($item != '') {
                    return response()->json(['status' => true, 'data' => $view]);
                } else {
                    return response()->json(['status' => false, 'data' => trans("lang.error")]);
                }
            }
        }
    }

    // print_xls
    public function print_xls($id)
    {
        $lang            =   'ar';
        $lang_val        =    ['ar' => 1, 'en' => 2];

        $setting = \App\Models\Setting::where('id', 1)->first(["name_" . $lang . " as name", "description_" . $lang . " as description"]);

        $data['setting'] = Setting::where('id', 1)->first();

        $item = Course::find($id);

        $data['order'] = MyCourses::leftJoin('clients as c', 'my_courses.client_id', '=', 'c.id')
            ->where('my_courses.courses_id', $id)
            ->leftJoin('system_constants as s', function ($join) {
                $join->on('s.value', '=', 'c.governorate')->where('s.type', 'governorate')->whereNull('s.deleted_at');
            })
            ->leftJoin('system_constants as sy', function ($join) {
                $join->on('sy.value', '=', 'c.city')->where('sy.type', 'city')->whereNull('sy.deleted_at');
            })
            ->leftJoin('system_constants as sys', function ($join) {
                $join->on('sys.value', '=', 'c.Degree')->where('sys.type', 'Degree')->whereNull('sys.deleted_at');
            })
            ->select("c.name as name", 'c.email as email', 'c.mobile as mobile', "s.name_ar as name_governorate", "sy.name_ar as name_city", "sys.name_ar as name_Degree")
            ->get();



        $table = '<table border="1" width="100%">
                    <tr>
                        <th  style="text-align:center;font-weight:bold;font-size:13px" colspan="6"> 
                        ' . $item->title . '
                        </th>
                    </tr>
                    <tr>
                        <th  style="text-align:center;font-weight:bold;font-size:13px">#</th>
                        <th  style="text-align:center;font-weight:bold;font-size:13px">الاسم	</th>
                        <th  style="text-align:center;font-weight:bold;font-size:13px">البريد الالكتروني	 </th>
                        <th  style="text-align:center;font-weight:bold;font-size:13px">رقم الجوال	</th>
                        <th  style="text-align:center;font-weight:bold;font-size:13px">الدرجة العلمية</th>
                        <th  style="text-align:center;font-weight:bold;font-size:13px">التقييم</th>

                    </tr>';
        if ($data['order']) {

            $i = 1;


            if (count($data['order']) > 0) {
                foreach ($data['order'] as $items) {
                    $table .= '<tr>
                                        <td style="text-align:center;font-size:11px">' . $i++ . '</td>
                                        <td style="text-align:center;font-size:11px"> ' . $items->name . '</td>
                                        <td style="text-align:center;font-size:11px"> ' . $items->email . '</td>
                                        <td style="text-align:center;font-size:11px"> ' . $items->mobile . '</td>

                                        <td style="text-align:center;font-size:11px"> ' . $items->name_Degree . '</td>
                                        <td style="text-align:center;font-size:11px"> ---</td>


                                    </tr>';
                }
            }
        }
        $table .= '</table>';



        @ob_start();
        echo  chr(239) . chr(187) . chr(191);
        echo $table;
        $filename = 'مسجلين_دورة_' . $item->title . '_' . date('Y-m-d');
        header("Content-Type: application/xls");
        header("Content-Disposition: attachment; filename=" . $filename . ".xls");
        header("Pragma: no-cache");
        header("Expires: 0");

        // return 'قيد البرمجة';
        // return view('site.trainer', compact('data', 'setting'));
    }













    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function videos(Request $request)
    {
        $course_id = $request->get('course_id');
        $videos = Video::where('course_id', $course_id)->get();
        $view = view('site.sub_profile.table-data-course-video', compact('videos'))->render();

        return response()->json(['status' => true, 'data' => $view]);
    }
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function addVideo(Request $request)
    {

        $course_id = $request->get('course_id');
        $title = $request->get('title');
        $url = $request->get('url');
        $image = $request->get('image');
        $file_flash = $request->file('file_flash');

        $type = $request->get('type');

        $rules = [
            'title' => 'required',
            // 'url' => 'required|url',
            'course_id' => 'required',
            // 'image' => 'required',

        ];

        $messages = [
            'title.required' => 'العنوان مطلوب',
            // 'url.required' => 'رابط الفيديو مطلوب',
            // 'url.url' => 'الرجاء التأكد من رابط الفيديو',
            'course_id.required' => 'الدورة مطلوبة',
            // 'image.required' => 'الصورة مطلوبة',

        ];

        $validator = \Validator::make(
            [
                'title' => $title,
                // 'url' => $url,
                'course_id' => $course_id,
                // 'image' => $image,

            ],
            $rules,
            $messages
        );

        if ($validator->fails()) {
            $all = collect($validator->errors()->getMessages())->map(function ($item) {
                return $item[0];
            });
            $strs = [];
            foreach ($all as $value) {
                $strs[] =  $value;
            }
            return response()->json(['status' => false, 'data' => implode(',', $strs)]);
        }
        if ($type == 3) {
            $rules = [
                'file_flash' => 'required',

            ];

            $messages = [
                'file_flash.required' => ' ملف فلاش مطلوب',

            ];

            $validator = \Validator::make(
                [
                    'file_flash' => $file_flash,

                ],
                $rules,
                $messages
            );

            if ($validator->fails()) {
                $all = collect($validator->errors()->getMessages())->map(function ($item) {
                    return $item[0];
                });
                $strs = [];
                foreach ($all as $value) {
                    $strs[] =  $value;
                }
                return response()->json(['status' => false, 'data' => implode(',', $strs)]);
            }
        } else {
            // $rules = [
            //     'url' => 'required|url',

            // ];

            // $messages = [
            //     'url.required' => 'الرابط  مطلوب',
            //     'url.url' => 'الرجاء التأكد من الرابط',

            // ];

            // $validator = \Validator::make(
            //     [
            //         'url' => $url,

            //     ],
            //     $rules,
            //     $messages
            // );

            // if ($validator->fails()) {
            //     $all = collect($validator->errors()->getMessages())->map(function ($item) {
            //         return $item[0];
            //     });
            //     $strs = [];
            //     foreach ($all as $value) {
            //         $strs[] =  $value;
            //     }
            //     return response()->json(['status' => false, 'data' => implode(',', $strs)]);
            // }
        }

        $course = Course::find($course_id);
        if (!$course) {
            return response()->json(['status' => false, 'data' => 'الدورة غير موجودة']);
        }


        $user_id = \Auth::user()->id;

        $video = new Video();
        $video->user_id = $user_id;
        $video->title = $title;
        $video->url = $url;
        $video->course_id = $course_id;
        $video->image = $image;
        $video->type = $type;

        $saved = $video->save();
        $max = $video->id;
        $myfile = '';
        // if ($request->hasFile('file_flash') && $file_flash->isValid()) {
        //     $ext = $file_flash->getClientOriginalExtension();
        //     if ($ext != 'zip') {
        //         return response()->json(['status' => false, 'data' => 'يجب أن تكون صيغة الملف .zip']);
        //     }
        //     $myfile = 'flip_' . strtotime(date("Y-m-d H:i:s")) . $max;
        //     $zip = new ZipArchive;
        //     $res = $zip->open($file_flash);
        //     if ($res === TRUE) {
        //         $zip->extractTo('uploads/' . $myfile);
        //         $zip->close();
        //     } else {
        //         return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الرفع']);
        //     }
        // }

        if ($type == 3) {
            $video->url = $myfile;
            $saved = $video->save();
        }

        if (!$saved) {
            return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
        }
        return response()->json(['status' => true, 'data' => 'تمت عملية الإضافة']);
    }
    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    public function deleteVideo(Request $request)
    {
        $id = $request->get('id');
        $item = Video::find($id);
        if ($item != '') {
            $deleted = $item->delete();
            if (!$deleted) {
                return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
            }
            return response()->json(['status' => true, 'data' => 'تم الحذف بنجاح']);
        } else {
            return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
        }
    }











    public function addrating(Request $request)
    {


        $clintid = (Auth::guard('clients')->user()->id); //الشخص الذي سوف يقيم
        if ($clintid) {
            // return $request;
            $stars_no = $request->get('rating_client'); //قيمة التقيم
            $rated_client = $request->get('id'); // رقم الدورة   
            $notes = $request->get('notes'); //الملاحظات
            $ClientsRate = MyCourses::where('courses_id', $rated_client)
                ->where('client_id', $clintid)
                ->where('stars_no', null)
                ->first();

            // if ($clintid == $rated_client) {
            //     return response()->json(['status' => false, 'data' => trans('lang.e1_rating')]);
            if (!$ClientsRate) {
                return response()->json(['status' => false, 'data' => 'عذراً . لقد تم تقيم المدرب مسبقاً']);
            } else {

                $rules = [
                    'stars_no' => 'required',
                    'rated_client' => 'required',
                    'notes' => 'required|max:255',
                ];

                $messages = [
                    'stars_no.required' => 'التقيم مطلوب ',
                    'rated_client.required' => trans('lang.Unauthorized'),
                    'notes.required' => ' الملاحظات مطلوبة',
                    'notes.max' => ' يجب ان تكون الملاحظات اقل من 255 حرف ',
                ];

                $validator = \Validator::make(
                    [
                        'stars_no' => $stars_no,
                        'rated_client' => $rated_client,
                        'notes' => $notes,
                    ],
                    $rules,
                    $messages
                );

                if ($validator->fails()) {
                    return response()->json(['status' => false, 'data_validator' => $validator->messages()]);
                    // return response()->json(['status' => false, 'data' => trans('lang.text_rate')]);
                }
                $courses_id = $ClientsRate->courses_id;
                $data_courses = Course::where('id', $courses_id)->first();
                $trainers = Trainers::where('id', $data_courses->trainers)->first();
                if ($trainers) {
                    $ClientsRate->stars_no = $stars_no;
                    $ClientsRate->notes = $notes;
                    $saved = $ClientsRate->save();
                    if ($saved) {
                        // ClientsRate
                        $trainers->rate_no = $trainers->rate_no + 1;
                        $trainers->stars_no = $trainers->stars_no + $stars_no;
                        $trainers->save();

                        $data_courses->rate_no = $data_courses->rate_no + 1;
                        $data_courses->stars_no = $data_courses->stars_no + $stars_no;
                        $data_courses->save();


                        $data['favorites'] = MyCourses::leftJoin('courses as t', 'my_courses.courses_id', '=', 't.id')->where('t.status', 1)
                            ->where('my_courses.client_id', $clintid)->where('my_courses.deleted_at', null)->orderBy('my_courses.id', 'desc')
                            ->get(['t.id', "t.title as name", "t.image as img", 't.price', 't.rating', 'my_courses.stars_no']);

                        $view = view('site.sub_profile.table-data-Favorite', compact('data'))->render();

                        return response()->json(['status' => true, 'data' => trans('lang.success'), 'view' => $view]);
                    } else {
                        return response()->json(['status' => false, 'data' => trans('lang.error')]);
                    }
                } else {
                    return response()->json(['status' => false, 'data' => trans('lang.error')]);
                }
            }
        } else {
            return response()->json(['status' => false, 'data' => trans('lang.error')]);
        }
    }
}
