<?php

namespace App\Http\Controllers\Admin;

use App\Models\Messages as MyModel;
use Illuminate\Http\Request;
use App\Mail\send_reply;
use App\Models\Setting;

class ContactUsController extends AdminController
{
    public function __construct()
    {
        // parent::__construct();
        // $this->middleware(['permission:contact|view_contact|reply_contact']);
    }
    //////////////////////////////////////////////
    public function index(Request $request)
    {
     
        $name  = $request->get('name');
        $data['message'] =  MyModel::select(['messages.id','messages.name','messages.email','messages.details','messages.mobile','messages.response']);
        
        if($name != ''){
            $data['message'] = $data['message']->where('messages.name', 'like', '%' .  $name . '%');
        }
        $data['message'] = $data['message']->orderBy('id','desc')->paginate(15);

        if ($request->ajax()) {
            return view('admin.contact.table-data', compact('data'))->render();
        }
        return view('admin.contact.index',compact('data'));
    }
  /***********************************************************************************************************************/
    public function view(Request $request){
     
        $id = $request->get('id');
        $item = MyModel::where('id',$id)->first(['id','name','email','mobile','details']);
        if($item != ''){
            return response()->json(['status' => true , 'data' => $item]);
        }else{
            return response()->json(['status' => false , 'message' => 'حدث خطأ']);
        }
    }

    public function reply(Request $request){
     
        $setting = Setting::where('id',1)->first('email');
        
        $id = $request->get('sender_id');
        $response = $request->get('response');
        if($response == ''){
            return response()->json(['status' => false , 'message' => 'جميع الحقول مطلوبة']);
        }
        $item = MyModel::find($id);
        if($item != ''){
            $item->response = $response;
            $saved = $item->save();
            if(!$saved){
                return response()->json(['status' => false , 'message' => 'حدث خطأ أثناء العملية']);
            }
            \Mail::to($item->email)->send(new send_reply($request,$setting->email));
            return response()->json(['status' => true , 'message' => 'تم الرد بنجاح']);
        }else{
            return response()->json(['status' => false , 'message' => 'حدث خطأ']);
        }
    }
/***********************************************************************************************************************************/

}