@extends('site.layout.layout')

@section('url'){{URL::to('/')}}/Universities @stop
@section('title') الجامعات @stop
@section('image'){{URL::to('/')}}/img/750x500/{{$setting->logo}} @stop
@section('description'){{\App\Http\Helpers\Helpers::stringReplace($setting->description,3)}} @stop

@section('css')
<style>

</style>
@endsection
@section('content')


<div class="ttm-page-title-row">
    <div class="ttm-page-title-row-inner ttm-textcolor-white">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-12">
                    <div class="page-title-heading">
                        <h2 class="title">الجامعات</h2>
                    </div>
                    <div class="breadcrumb-wrapper">
                        {{-- <span> --}}
                            {{-- <a title="Homepage" href="{{URL::to('/')}}">{{ __('app.home') }}</a> --}}
                        {{-- </span> --}}
                        {{-- <span class="ttm-bread-sep">&nbsp;&gt;&nbsp;</span> --}}
                        {{-- <span class="current">{{$data['static']->title}}</span> --}}
                    </div>
                </div>
            </div>
        </div>
    </div>                    
</div>
<div class="site-main">
    <section class="ttm-row team-section ttm-bgcolor-grey clearfix" style="background-color: unset;">
        <div class="container">
            <div class="row justify-content-center">
                @foreach ($data['universities'] as $item)
                    <div class="ttm-box-col-wrapper col-md-2 col-sm-4">
                        <div class="featured-imagebox featured-imagebox-team style2" >
                            <a href="{{URL::to('/')}}/university/{{$item->id}}">
                                <div class="featured-thumbnail">
                                    <img class="img-fluid lazyload" data-src="{{URL::to('/')}}/uploads/{{$item->photo}}" style="object-fit: contain;" alt="{{$item->title_ar}}"> 
                                </div>
                            </a>
                            <h5><a href="{{URL::to('/')}}/university/{{$item->id}}">{{$item->title_ar}} </a></h5>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </section>
</div>
@endsection
@section('js')
<script>


</script>
@endsection