

@extends('site.layout.layout')

@section('url'){{URL::to('/')}}/trainer/{{  $data['trainer']->id }} @stop
@section('title') {{$data['trainer']->title_ar }}@stop
@section('image'){{URL::to('/')}}/img/750x500/{{$data['trainer']->photo}} @stop
@section('description'){{\App\Http\Helpers\Helpers::stringReplace($data['trainer']->details_ar)}} @stop

@section('css')
<style>

#course-reviews i.far,#course-reviews i.fas{
    display: inline-block;
    font: normal normal normal 14px / 1 FontAwesome;
    font-size: inherit;
    text-rendering: auto;
    -webkit-font-smoothing: antialiased;
    width: 15px;
    font-size: 15px;

}



.course-reviews-list li .review-author img {
    margin-right: unset;
    margin-left: 20px;

}
.course-reviews-list li h4.user-name, .review-stars-rated {
    margin: 0 0 10px 14px;
}
.course-reviews-list li h4.user-name, .review-stars-rated {
    font-size: 18px !important;
    line-height: 24px !important;
    margin: 0 14px 10px 0 !important;
}
</style>
@endsection
@section('content')
<div class="ttm-page-title-row">
    <div class="ttm-page-title-row-inner ttm-textcolor-white">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-12">
                    <div class="page-title-heading">
                        <h2 class="title"> {{$data['trainer']->title_ar }}</h2>
                    </div>
                    <div class="breadcrumb-wrapper">
                    </div>
                </div>
            </div>
        </div>
    </div>                    
</div>








   <!--site-main start-->
   <div class="site-main">


    <section class="ttm-row clearfix">
        <div class="ttm-team-member-single-content-wrapper ttm-team-member-view-default">
            <div class="container">
                <div class="ttm-team-member-single-content row">
                    <div class="col-lg-12">
                        <!-- ttm-learn-press-profile-header -->
                        <div class="ttm-learn-press-profile-header">
                            <div class="ttm-learn-press-profile-item clearfix">
                                <div class="ttm-learn-press-left">
                                    <img src="{{URL::to('/')}}/uploads/{{$data['trainer']->photo}}" 
                                    style="height: 150px; width: 150px; object-fit: cover;"
                                    alt="{{$data['trainer']->title_ar}}" 
                                    class="avatar alignnone photo">
                                </div>
                                <div class="ttm-learn-press-right">
                                    <h2 class="ttm-authorname">
                                        {{$data['trainer']->title_ar}}
                                     </h2>
                                    <div class="ttm_instructor_designation">
                                        <p>
                                            {{$data['trainer']->details_ar}}
                                        </p>

                                    </div>
                                    {{-- <div class="ttm-social-links-wrapper">
                                        <ul class="social-icons">
                                            <li class="social-facebook">
                                                <a class="tooltip-top" target="_blank" href="https://www.facebook.com/preyantechnosys19" data-tooltip="Facebook"><i class="fa fa-facebook" aria-hidden="true"></i></a>
                                            </li>
                                            <li class="social-twitter">
                                                <a class="tooltip-top" target="_blank" href="https://twitter.com/PreyanTechnosys" data-tooltip="Twitter"><i class="fa fa-twitter" aria-hidden="true"></i></a>
                                            </li>
                                            <li class="social-gplus">
                                                <a class="tooltip-top" target="_blank" href="https://www.instagram.com/preyan_technosys/" data-tooltip="Instagram"><i class="fa fa-instagram" aria-hidden="true"></i></a>
                                            </li>
                                        </ul>
                                    </div> --}}
                                </div>      
                            </div>
                        </div>
                        <!-- ttm-learn-press-profile-header end -->
                        <div id="learn-press-profile-nav">
                           
                            <div class="mt-30">
                                <div class="row">
                                    <div class="col-lg-2 col-md-2 col-sm-12">
                                        <h4> الدورات التدريبية </h4>
                                    </div>
                                    <div class="col-lg-10 col-md-10 col-sm-12">
                                        <div class="content">
                                            <div class="row">
                                                @foreach ($data['courses'] as $item)

                                                    <div class="ttm-box-col-wrapper col-lg-4 col-sm-6 col-md-4 col-xs-12">
                                                        <div class="featured-imagebox featured-imagebox-course">
                                                            <div class="ttm-post-thumbnail featured-thumbnail"> 
                                                                <img style="width:310px; height:239px; object-fit: cover;" class="img-fluid lazyload" src="{{URL::to('/')}}/uploads/{{$item->image}}" data-src="{{URL::to('/')}}/uploads/{{$item->image}}" alt="{{$item->title}}"> 
                                                            </div>
                                                            {{-- x470 --}}
                                                            <div class="featured-content featured-content-post">
                                                                <div class="featured-content-post-inner">
                                                                    <div class="post-title featured-title">
                                                                        <h5>
                                                                            <a href="{{URL::to('/')}}/cours/{{$item->id}}">
                                                                                {{$item->title}}
                                                                            </a>
                                                                        </h5>
                                                                    </div>
                                                                    <div class="post-desc featured-desc">
                                                                        {!!\App\Http\Helpers\Helpers::cutText($item->details,200,true)!!}
                                                                        {{-- <p>هناك حقيقة مثبتة منذ زمن طويل وهي أن المحتوى المقروء لصفحة ما سيلهي القارئ عن التر...</p> --}}
                                                                    </div>
                                                                </div>
                                                                <div class="ttm-course-box-meta">
                                                                    <div class="ttm-enrolled">
                                                                        <span class="ttm-count ttm-meta-line">
                                                                            <i class="fa fa-files-o" aria-hidden="true"></i>
                                                                            {{$item->videos_count}}
                                                                        </span>
                                                                    </div>  
                                                                    <span class="ttm-lp-price">
                                                                        <ins> {{$item->price}}  ر.س  </ins>
                                                                    </span> 
                                                                    

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                            @endforeach
                                                
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="mt-50">
                                <div class="row">
                                    <div class="col-lg-2 col-md-2 col-sm-12">
                                        <h4> التقييمات </h4>
                                    </div>
                                    <div class="col-lg-10 col-md-10 col-sm-12">
                                        <div class="content">
                                            <div class="course-rates">
                                                {{-- قيد البرمجة --}}
                                                <div id="course-reviews">
                                                    <ul class="course-reviews-list">
                                                        @foreach ($data['rating'] as $item)
                                                            <li >
                                                                <div class="review-author">
                                                                    <img src="{{URL::to('/')}}/uploads/{{$item->client_img}}" 
                                                                    width="96" 
                                                                    height="96" 
                                                                    alt="{{$item->client_name}}" class="avatar photo">
                                                                </div>
                                                                <div class="review-author-info">
                                                                    <div class="rev_head">
                                                                        <h4 class="user-name">{{$item->client_name}}</h4>
                                                                        <div class="review-stars-rated" title="5 out of 5 stars">
                                                                            <div class="pull-right userRating client_rating" data-rating="{{$item->stars_no}}"></div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="rev_content">
                                                                        {{-- <div class="review-title">Best Course </div> --}}
                                                                        <div class="review-text">
                                                                            {{$item->notes }}
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </li>
                                                        @endforeach
                                                        
                                                    </ul>
                                                </div>
                                            </div><!-- content-inner end-->
                                        </div>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
  
</div><!--site-main end-->
@endsection

@section('js')
    <script>
        $(document).ready(function(){
            rating();
        })
        function rating(){
            $.each($('.client_rating'), function (indexInArray, valueOfElement) {
            $(this).rating({
                "value": $(this).data('rating'),
                "readonly":true,
                "half":true
            });
            });
        }
    </script>
@endsection
