@extends('site.layout.layout')
@section('url'){{URL::to('/')}}/{{App::getLocale()}}/tags/{{$data['tags']->id}}@stop
@section('title'){{\App\Http\Helpers\Helpers::stringReplace($data['tags']->name,3)}}@stop
@section('content')




<section class="page-title">
  <div class="container">
      <div class="row">
          <div class="col col-xs-12">
              <h2>{{ __('app.tag') }}</h2>
              <ol class="breadcrumb">
                  <li class="">{{$data['tags']->name}}</li>
                  <li class="float-right"><a href="{{URL::to('/')}}/{{App::getLocale()}}">{{ __('app.home') }}</a></li>
              </ol>
          </div>
      </div> 
  </div> 
</section>   

<section class="section-padding" style="padding: 30px 0;">
  <div class="container">
     
      <div class="row d-flex">
        @if($data['posts'] and count($data['posts']) > 0)

        
          @foreach ($data['posts'] as $item)
                <article class="Articles col-lg-4 col-md-6 mb-30 wow fadeInUp  animated">
                    <div class="post-card-1 border-radius-10 hover-up">
                        <div class="post-thumb thumb-overlay img-hover-slide position-relative"
                            style="background-image: url({{URL::to('/')}}/uploads/{{$item->main_image}})">
                            <!-- <a class="img-link"
                                href="https://www.amal-coalition.ps/ar/posts/14/تحالف-أمل-لمناهضة-العنف-ضد-المرأة-بالتعاون-ملتقى-إعلاميات-الجنوب&nbsp;يعقدان-ورشة-عمل-توعوية-حول-قانون-حماية-الأسرة-من-العنف">
                            </a> -->
                        </div>
                        <div class="post-content p-30">
                            <div class="entry-meta meta-0 font-small mb-10">
                                <a href="{{URL::to('/')}}/{{App::getLocale()}}/posts/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}">
                                    <span class="post-cat text-uppercase">
                                    {{\App\Http\Helpers\Helpers::cutText($item->title,60,true)}}
                                    </span>
                                </a>
                            </div>
                           
                            <div class="meta">
                                <span><i class="fa fa-calendar" style="color: #009D57 ;"></i>
                                    @if(\App::getLocale() == 'ar')

                                    {{\App\Http\Helpers\Helpers::getDayName($item->date)}} , {{date('d',strtotime($item->date))}} {{\App\Http\Helpers\Helpers::get_month_name(date('M',strtotime($item->date)))}}  {{date('Y',strtotime($item->date))}} 
                                    @else 
                                    {{\App\Http\Helpers\Helpers::getDayNameEn($item->date)}} , {{date('d',strtotime($item->date))}} {{\App\Http\Helpers\Helpers::get_month_nameEn(date('M',strtotime($item->date)))}}  {{date('Y',strtotime($item->date))}} 

                                    @endif                                </span>
                                <a href="{{URL::to('/')}}/{{App::getLocale()}}/posts/{{$item->id}}/{{\App\Http\Helpers\Helpers::stringReplace($item->title,2)}}" class="float-left" style="color: #009D57; font-size: 14px;">  {{ __('app.See_More') }}  &nbsp;&nbsp; <i class="fa fa-angle-left"></i>
                                </a>
                            </div>

                        </div>
                    </div>
                </article>
            @endforeach
          @else
                <div class="col-md-12 text-center">
                    <p> {{ __('lang.no_results') }} </p>
                    
                </div>
            @endif

      </div>
     
  </div>
</section>



   
@stop   