@extends('site.layout.layout')

@section('url'){{URL::to('/')}}/{{App::getLocale()}}/profile @stop
@section('title'){{ __('app.profile') }} @stop
@section('image'){{URL::to('/')}}/img/750x500/{{$setting->logo}} @stop
@section('description'){{\App\Http\Helpers\Helpers::stringReplace('',3)}} @stop

@section('css')
<style>
section {
    padding: 2em;
    display: flex;
    justify-content: center;
}

#profileSettings ul {
    background: #F8F8F8;
    padding: 0;
    display: flex;
    justify-content: center;
    width: 100%;

}
#profileSettings ul li a {
    border-radius: 0;
    background-color: #f8f8f8;
    color: #000;
    min-width: 170px;
    height: 50px;
    text-align: center;
    transition: .3s ease-in-out;
    line-height: 35px;

}
#profileSettings ul li.active a{
    background: #1a2b57;
    color: #fff;
}
.profileContent .card img {
  height: 120px;
    width: 120px;
    margin: 0 auto;
    margin-top: 15px;
    border: unset;
    border-radius: 50%;


}
.profileContent .card.card-aside {
    border-top-left-radius: 30px;
    overflow: hidden;
    padding: 0;
    border: 0;

}
.profileContent .card {
    background: #fff;
    box-shadow: 1px 1px 20px 2px #e2e3e7;
    border: 0;

}
a.rat,
a.show_voice,
a.showDetails,
a.editProfile {
    background: #1a2b57;
    border-radius: 100%;
    padding: 9px 10px;
    font-size: 20px;
    display: flex;
    justify-content: center;
    align-items: center;
    color: #fff;
}

.required{
    color: red;
}
.swal2-container.swal2-rtl.swal2-center.swal2-backdrop-show {
    z-index: 99999999999 !important;
}

.card {
    position: relative;
    display: -ms-flexbox;
    display: flex;
    -ms-flex-direction: column;
    flex-direction: column;
    min-width: 0;
    word-wrap: break-word;
    background-color: #fff;
    background-clip: border-box;
    border: 1px solid rgba(0,0,0,.125);
    border-radius: 0.25rem;
}
.card-header {
    padding: 0.75rem 1.25rem;
    margin-bottom: 0;
    background-color: rgba(0,0,0,.03);
    border-bottom: 1px solid rgba(0,0,0,.125);
}
.card-header:first-child {
    border-radius: calc(0.25rem - 1px) calc(0.25rem - 1px) 0 0;
}
.card-body {
    -ms-flex: 1 1 auto;
    flex: 1 1 auto;
    padding: 1.25rem;
}

tr .remove-btn {
    position: relative;
    display: inline-block;
    font-size: 18px;
    color: red;
    width: 40px;
    height: 40px;
    line-height: 40px;
    border-radius: 50px;
    text-align: center;
    border: 1px solid red;
    -webkit-transition: all 500ms ease;
    -ms-transition: all 500ms ease;
    -o-transition: all 500ms ease;
    -moz-transition: all 500ms ease;
    transition: all 500ms ease;
}

.wpcf7-form input, .wpcf7-form textarea, .wpcf7-form select {
    border: 1px solid #ccc !important;
}

.pull-right {
    float: left;
}

.btn_save_page{
    background-color: #1a2b57;

}

select.form-control:not([size]):not([multiple]) {
    height: calc(2.25rem + 12px);
}
@media (min-width: 992px) {
    .modal-lg {
        max-width: 1072px;
    }
}
</style>
@endsection
@section('content')
<div class="ttm-page-title-row">
    <div class="ttm-page-title-row-inner ttm-textcolor-white">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-12">
                    <div class="page-title-heading">
                        <h2 class="title">{{ __('app.profile') }}</h2>
                    </div>
                    <div class="breadcrumb-wrapper">
                        {{-- <span> --}}
                            {{-- <a title="Homepage" href="{{URL::to('/')}}">{{ __('app.home') }}</a> --}}
                        {{-- </span> --}}
                        {{-- <span class="ttm-bread-sep">&nbsp;&gt;&nbsp;</span> --}}
                        {{-- <span class="current">{{$data['static']->title}}</span> --}}
                    </div>
                </div>
            </div>
        </div>
    </div>                    
</div>
<div class="site-main">
    <div class="ttm-row why_choose2-section clearfix">
        <div class="container">
            <div class="row justify-content-center profileContent">
                <div class="col-md-4">
                    <div class=" profile-data float-right">
                        <div class="card card-aside">
        
                            <img src="/uploads/{{\Auth::guard('trainers')->user()->photo}}" class="card-img-top img_profile" alt=""
                            style="
                                width: 70%;
                                margin: 0 auto;
                                margin-top: 20px;
                                border-radius: 50%;
                                height: 250px;
                            ">
                           
                            <div class="card-body" style="font-size: 13px;">
                                <bdo dir="rtl"></bdo>
                                <table class="table table-borderless text-right">
                                    <tbody>
                                        <tr>
                                        <td><b> {{ __('lang.name') }} </b></td>
                                        <td class="p_name"> {{\Auth::guard('trainers')->user()->title_ar}} </td>
                                        </tr>
                                        <tr>
                                        <td><b>{{ __('lang.email') }} </b></td>
                                        <td class="p_email"> {{\Auth::guard('trainers')->user()->email}}</td>
                                        </tr>
                                        <tr>
                                        <td><b> {{ __('lang.mobile') }}</b></td>
                                        <td class="p_mobile" style="direction: ltr;"> {{\Auth::guard('trainers')->user()->mobile}}</td>
                                        </tr>
            
            
                                    </tbody>
                                    </table>
                            </div>
                        </div>

                    </div>
                </div>
                <div class="col-lg-8">
                    <div class="ttm-tabs tabs-style-01" data-effect="fadeIn">
                        <ul class="tabs clearfix">
                            <li class="tab active"><a href="#"> {{ __('app.Main_data') }}  </a></li>
                            <li class="tab"><a href="#" id="my_courses"> {{ __('app.my_courses') }} </a></li>
                            <li id="logout_trainers"><a href="{{URL::to('/')}}/logout_trainers">  {{ __('app.logout') }} </a></li>
                        </ul>
                        <div class="content-tab ">
                            
                            <div class="content-inner active">
                                <div class="card card-main">
                                    <div class="card-header">
                                        <h4 class="text-right">  {{ __('lang.profile') }}
                                            <a title=" {{ __('lang.Edit_profile') }}"   data-id="{{\Auth::guard('trainers')->user()->id}}" class="pull-right update editProfile" href="javascript:void(0);">
                                                <i class="fa fa-edit"></i>
                                            </a>
                                        </h4>
                                    </div>
                                    <div class="card-body">
                                        <div class=" table-responsive">
                                            <table class="table table-borderless">
                                                <thead>
                                                    <tr>
                                                        <td style="width: 20%;"><b> {{ __('lang.name') }}:</b></td>
                                                        <td class="p_name">  {{\Auth::guard('trainers')->user()->title_ar}}  </td>
                                                    </tr>
                                                    <tr>
                                                        <td><b>{{ __('lang.email') }} :</b></td>
                                                        <td class="p_email"> {{\Auth::guard('trainers')->user()->email}}</td>
                                                    </tr>
                                                    <tr>
                                                        <td><b>{{ __('lang.mobile') }} :</b></td>
                                                        <td class="p_mobile" style="direction: ltr;">{{\Auth::guard('trainers')->user()->mobile}}</td>
                                                    </tr>
                                                    {{-- <tr>
                                                        <td><b>{{ __('app.gender') }} :</b></td>
                                                        <td class="p_gender" style="direction: ltr;">
                                                            @if(\Auth::guard('trainers')->user()->gender == 1)
                                                                {{ __('app.male') }}
                                                            @elseif(\Auth::guard('trainers')->user()->gender == 2)
                                                                {{ __('app.female') }}
                                                            @endif
                                                        </td>
                                                    </tr> --}}
                                                    <tr>
                                                        <td><b> الجامعة :</b></td>
                                                        <td class="p_universities" style="direction: ltr;">{{$data['clients']->name_universities}}</td>
                                                    </tr>
                                                    <tr>
                                                        <td><b>{{ __('app.dob') }} :</b></td>
                                                        <td class="p_dob" style="direction: ltr;">{{\Auth::guard('trainers')->user()->dob}}</td>
                                                    </tr>
                                                    <tr>
                                                        <td><b> نبذة :</b></td>
                                                        <td class="p_note" style="direction: ltr;">{{$data['clients']->details_ar}}</td>
                                                    </tr>
                                                    
                                                    {{-- name_Degree --}}
                                                    {{-- <tr>
                                                        <td><b>{{ __('app.governorate') }} :</b></td>
                                                        <td class="p_governorate" style="direction: ltr;">{{$data['clients']->name_governorate}}</td>
                                                    </tr>
                                                    <tr>
                                                        <td><b>{{ __('app.city') }} :</b></td>
                                                        <td class="p_city" style="direction: ltr;">{{$data['clients']->name_city}}</td>
                                                    </tr>
                                                    <tr>
                                                        <td><b>{{ __('app.title') }} :</b></td>
                                                        <td class="p_title" style="direction: ltr;">{{\Auth::guard('trainers')->user()->title}}</td>
                                                    </tr>
                                                    
            
                                                    <tr>
                                                        <td><b>{{ __('app.Degree') }} :</b></td>
                                                        <td class="p_Degree" style="direction: ltr;">{{$data['clients']->name_Degree}}</td>
                                                    </tr>
                                                    <tr>
                                                        <td><b>{{ __('app.Specialization') }} :</b></td>
                                                        <td class="p_Specialization" style="direction: ltr;">{{\Auth::guard('trainers')->user()->Specialization}}</td>
                                                    </tr> --}}
                                                   
            
            
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="content-inner" style="display: none;">
                                <div class="card card-main">
                                    <div class="card-header">
                                            <h4 class="text-right">  
                                                {{ __('app.my_courses') }} 
                                            
                                                <a title=" اضافة دورة"   data-id="{{\Auth::guard('trainers')->user()->id}}" class="pull-right addcourses editProfile" href="javascript:void(0);">
                                                    <i class="fa fa-plus"></i>
                                                </a>
                                            </h4>
                                    </div>
                                    <div class="card-body"id="table-container">
                                        @include('site.sub_profile.table-data-course')
                                        {{-- قيد البرمجة  --}}
                                    </div>
                                </div>
                            </div>
                        </div>


                        
                    </div>
                </div>
            </div>
        </div>
    </div>

    
</div>



@include('site.sub_profile.update_clint_trainers')

@endsection
@section('js')
<script src="{{asset('admin_assets/ckeditor/ckeditor.js')}}" type="text/javascript"></script>
<script src="{{asset('admin_assets/ckeditor/styles.js')}}" type="text/javascript"></script>
<script>
    // onkeypress="return isNumberKey(event)"
        function isNumberKey(evt){
            var charCode = (evt.which) ? evt.which : event.keyCode
            if (charCode > 31 && (charCode < 48 || charCode > 57))
                return false;
            return true;
        }
    function CKupdate(){
        for ( instance in CKEDITOR.instances )
            CKEDITOR.instances[instance].updateElement();
        }
    $(document).on('click', '#update_clint .close', function (e) {
        $('#update_clint').hide();
    });
    $(document).on('click', '#update_clint #close', function (e) {
        $('#update_clint').hide();
    });
    $(document).on('click', '#add_courses .close', function (e) {
        $('#add_courses').hide();
    });
    $(document).on('click', '#add_courses #close', function (e) {
        $('#add_courses').hide();
    });
    $(document).on('click', '#registered_courses .close', function (e) {
        $('#registered_courses').hide();
    });
    $(document).on('click', '#registered_courses #close', function (e) {
        $('#registered_courses').hide();
    });
    $(document).on('click', '#view_videos .close', function (e) {
        $('#view_videos').hide();
    });
    $(document).on('click', '#view_videos #close', function (e) {
        $('#view_videos').hide();
    });
    
    
    $(document).ready(function(){
        var new_tap = window.location.hash
        if(new_tap === '#my_courses') {
            $('#my_courses').click();
        }
        
    })
    /*************************************************/
    $(document).on('change','#form_update_clint #governorate',function(e){
        var id = $(this).val();
        $('#form_update_clint #loading').show();
        $.ajax({
            url: "{{URL::to('/')}}/get_city",
            type: "get",
            dataType: "JSON",
            data: {
                id: id
            },
            success: function(data){
                $('#form_update_clint #loading').hide();
                if(data['status'] == true){
                    $('#form_update_clint #city').empty().html(data.data);
                }else{
                swal({
                        title: "",
                        text: data["data"],
                        type: "error",
                        showCancelButton: false,
                        confirmButtonColor: "#DD6B55",
                        confirmButtonText: "حسنا",
                        cancelButtonText: "الغاء",
                        closeOnConfirm: true,
                        closeOnCancel: true
                    });
                }
            },
            complete: function () {

            }
        });
    });

    // add_courses
    $(document).on('click', '.addcourses', function (e) {
        $('#form_add_courses').find('.id').val(0);
        CKEDITOR.instances['details'].setData('');
        $('.form_add_courses  .category_id').val('');
        $('.form_add_courses  .price').val('');
        $('.form_add_courses  .photo').val('');
        $('#add_courses .btn_save_page').text('إضافة ');
        $('#add_courses .modal-title').text('إضافة دورة ');

        
        // btn_save_page
        $('#add_courses').show();
    });
            /*************************************************/

    $(document).on('click', '.updateDetails', function () {
            $('#preloader').css('display', '');
            $('#status').css('display', '');
			$('#form_add_courses').find('.id').val(0);
            var id = $(this).data('id');
            $('#form_add_courses .id').val(id);
            $.ajax({
                url: "{{URL::to('/')}}/edit_courses",
                type: "get",
                dataType: "JSON",
                data: {
                    id: id
                },

                success: function(data){

					if(data['status'] == true){
						$(".form_add_courses .title").val(data['data']['title']);
                        $(".form_add_courses .price").val(data['data']['price']);
						CKEDITOR.instances['details'].setData(data['data']['details']);
                        $(".form_add_courses .category_id").val(data['data']['category_id']);
                        // if(data['data']['image']){
                        //     $('.img_review img').attr('src','/uploads/'+data['data']['image']);
                        // }
					}

                },

                complete: function () {
                    $('#preloader').css('display','none');
                    $('#status').css('display','none');
                    $('#add_courses .btn_save_page').text('تعديل ');
                    $('#add_courses .modal-title').text('تعديل الدورة ');
                    $('#add_courses').show();
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    swal({title: 'حدث خطأ غير معروف، الرجاء المحاولة فيما بعد', type: "error"});
                }
            });
            $('#add_page .modal-title').html('تعديل بيانات');
        });
    $('.form_add_courses').on('submit', function(e){
        e.preventDefault();
        var formData = new FormData(this);
        var id= $('#form_add_courses').find('.id').val();

        $('#preloader').css('display', '');
        $('#status').css('display', '');
        if(id == 0){
            var url="{{URL::to('/')}}/add_courses";
        }else{
            var url="{{URL::to('/')}}/update_courses";
        }
        $.ajax({
            url: url,
            type: "POST",
            dataType: "JSON",
            cache:false,
            contentType: false,
            processData: false,
            data: formData,
            success: function(data) {
                // $('#update_clint #loading').hide();

                if (data["status"] == true) {
                    $('#preloader').css('display','none');
                    $('#status').css('display','none');
                    Swal.fire({
                        title: "",
                        text: data["data"],
                        icon: "success",
                        showCancelButton: false,
                        confirmButtonColor: "#0c3591",
                        confirmButtonText: '{{__('lang.ok')}}',
                        cancelButtonText: '{{__('lang.cancel')}}',
                        closeOnConfirm: true,
                        closeOnCancel: true
                    });
                            $('#add_courses').hide();
                            $('.form_add_courses .title').val('');
                            $('.form_add_courses  .category_id').val('');
                            $('.form_add_courses  .price').val('');
                            $('.form_add_courses  .photo').val('');
                            CKEDITOR.instances['details'].setData('');


                            $("#table-container").empty().html(data["view"]);

                } else {
                    $('#preloader').css('display','none');
                    $('#status').css('display','none');
                    if(data['data_validator']!=null){
                        var dt = '<ul>';
                        $.each(data["data_validator"], function (key, value) {
                            dt = dt + '<li>' + value + '</li>';
                        })
                        dt =dt+ '</ul>';
                        toastr["error"](dt)
                    }else{
                        $('#preloader').css('display','none');
                        $('#status').css('display','none');
                        // toastr["error"](data["data"])
                        Swal.fire({
                            title: "",
                            text: data["data"],
                            icon: "error",
                            showCancelButton: false,
                            confirmButtonColor: "#0c3591",
                            confirmButtonText: '{{__('lang.ok')}}',
                            cancelButtonText: '{{__('lang.cancel')}}',
                            closeOnConfirm: true,
                            closeOnCancel: true
                        });
                    }
                }

            }
        });
    });
    // 







        $(document).on('click', '.update', function (e) {
            e.preventDefault();
            $('#preloader').css('display', '');
            $('#status').css('display', '');


            var id = $(this).data('id');
            $.ajax({
                url: "{{URL::to('/')}}/edit_profile_trainers",
                type: "get",
                dataType: "JSON",
                data: {
                    id: id
                },
                success: function(data){
					if(data['status'] == true){
                    $('#form_update_clint').find(".id").val(data['data']['id']);
                    $('#form_update_clint').find(".name").val(data['data']['title_ar']);
                    $('#form_update_clint').find(".email").val(data['data']['email']);
                    $('#form_update_clint').find(".mobile").val(data['data']['mobile']);

                    $('#form_update_clint').find(".gender").val(data['data']['gender']);
                    $('#form_update_clint').find(".dob").val(data['data']['dob']);
                    $('#form_update_clint').find(".governorate").val(data['data']['governorate']);
                    $('#form_update_clint').find(".city").empty().html(data['options']);

                    $('#form_update_clint').find(".title").val(data['data']['title']);
                    $('#form_update_clint').find(".Degree").val(data['data']['Degree']);
                    $('#form_update_clint').find(".Specialization").val(data['data']['Specialization']);
                    $('#form_update_clint').find(".note").val(data['data']['details_ar']);

                    
                    
                    
                    
                    
                    $('#form_update_clint').find(".city").val(data['data']['city']);


                    $('#form_update_clint').find(".password").val('');

                    }
                },
                complete: function () {
                    $('#preloader').css('display','none');
                    $('#status').css('display','none');
                    
                    $('#update_clint').show();
                },
            })
        });

</script>
<script>
            $('.form_update_clint').on('submit', function(e){
                    e.preventDefault();
                    var formData = new FormData(this);

                    $('#preloader').css('display', '');
                    $('#status').css('display', '');


                        $.ajax({
                            url: "{{URL::to('/')}}/update_profile_trainers",
                            type: "POST",
                            dataType: "JSON",
                            cache:false,
                            contentType: false,
                            processData: false,
                            data: formData,
                            success: function(data) {
                                $('#update_clint #loading').hide();

                            if (data["status"] == true) {
                                $('#preloader').css('display','none');
                                $('#status').css('display','none');
                                Swal.fire({
                                    title: "",
                                    text: data["data"],
                                    icon: "success",
                                    showCancelButton: false,
                                    confirmButtonColor: "#0c3591",
                                    confirmButtonText: '{{__('lang.ok')}}',
                                    cancelButtonText: '{{__('lang.cancel')}}',
                                    closeOnConfirm: true,
                                    closeOnCancel: true
                                });
                                        $('#update_clint').hide();
                                        $('.p_name').html(data['client']['title_ar']);
                                        $('.p_email').html(data['client']['email']);
                                        $('.p_mobile').html(data['client']['mobile']);
                                        $('.p_dob').html(data['client']['dob']);
                                        $('.p_universities').html(data['client']['name_universities']);
                                        $('.p_note').html(data['client']['details_ar']);

                                        
                                        $('.img_profile').attr('src','/uploads/'+data['client']['photo']);
                                        $(".photo").val('');
                            } else {
                                $('#preloader').css('display','none');
                                $('#status').css('display','none');
                                if(data['data_validator']!=null){
                                    var dt = '<ul>';
                                    $.each(data["data_validator"], function (key, value) {
                                        dt = dt + '<li>' + value + '</li>';
                                    })
                                    dt =dt+ '</ul>';
                                    toastr["error"](dt)

                                }else{
                                    $('#preloader').css('display','none');
                                    $('#status').css('display','none');
                                    // toastr["error"](data["data"])
                                    Swal.fire({
                                        title: "",
                                        text: data["data"],
                                        icon: "error",
                                        showCancelButton: false,
                                        confirmButtonColor: "#0c3591",
                                        confirmButtonText: '{{__('lang.ok')}}',
                                        cancelButtonText: '{{__('lang.cancel')}}',
                                        closeOnConfirm: true,
                                        closeOnCancel: true
                                    });

                                }


                            }

                            }
                        });

                        


            });
    </script>
    <script>
    $('body').on('click','.addToFavorite',function(){
        $('#addNewpageForm_tocard #loading').show();


        var id = $(this).data('id');
        $this = $(this);
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        $.ajax({
            url: "{{URL::to('/')}}/{{App::getLocale()}}/removeCours",
            type: "POST",
            dataType: "JSON",
            data:{
               id:id
               },
            success: function(data) {
                $('#addNewpageForm_tocard #loading').hide();

              if (data["status"] == true) {

                        Swal.fire({
                            title: "",
                            text: data['data'],
                            icon: "success",
                            showCancelButton: false,
                            confirmButtonColor: "#0c3591",
                            confirmButtonText: '{{__('lang.ok')}}',
                            cancelButtonText: '{{__('lang.cancel')}}',
                            closeOnConfirm: true,
                            closeOnCancel: true
                        });

                    $("#table-container").empty().html(data["view"]);

              } else {

                 Swal.fire({
                    title: "",
                    text: data["data"],
                    icon: "error",
                    showCancelButton: false,
                    confirmButtonColor: "#0c3591",
                    confirmButtonText: '{{__('lang.ok')}}',
                    cancelButtonText: '{{__('lang.cancel')}}',
                    closeOnConfirm: true,
                    closeOnCancel: true
                });


              }

            }
        });

    });
    $('body').on('click','#logout_trainers',function(){
        window.location.href = "{{URL::to('/')}}/logout_trainers";
    });


    $(document).on('click','.show_fav',function(e){
        id = $(this).data('id');
        $('#preloader').css('display', '');
        $('#status').css('display', '');
        $.ajax({
            url: "{{URL::to('/')}}/showRegisteredCours",
            type: "get",
            dataType: "JSON",
            data: {
                id: id,
            },
            success: function(data){
                $('#registered_courses #registeredCourses').html(data['data']);
            },
            complete: function () {
                $('#preloader').css('display','none');
                $('#status').css('display','none');
                $('#registered_courses').show();
            }
        })
    });
    </script>
    <script>

$(document).on('click','.videos',function(e){
        var id = $(this).data('id');
        getVideos(id);
    });

    
    function getVideos(id){
        $('#view_videos .title').val('');
        $('#view_videos .url').val('');
        $('#view_videos .type').val('');
        $('#view_videos .file_flash').val('');
        $('#view_videos #image').val('');
        $('#view_videos').find(".div_flip").addClass('d-none');

        $('#view_videos .course_id').val(id)
        $.ajax({
            url: "{{URL::to('/')}}/videos",
            type: "get",
            dataType: "JSON",
            data: {
                course_id: id
            },
            success: function(data){
                if(data['status'] == true){
                    $('#view_videos .table-reponsive').html(data.data)
                }
            },
            complete: function () {
                $('#view_videos').show();
            },
            error: function (jqXHR, textStatus, errorThrown) {
                swal({title: 'حدث خطأ غير معروف، الرجاء المحاولة فيما بعد', type: "error"});
            }
        });
    }
    
        $('#view_videos .addNewpageForm').on('submit', function(e){
        var course_id = $('#view_videos .course_id').val()
        e.preventDefault();
        $('#preloader').css('display', '');
        $('#status').css('display', '');
        var formData = new FormData(this);
       
        var id = $(".rowIdUpdate").val();
            $.ajax({
                url: "{{URL::to('/')}}/videos/add",
                type: "post",
                cache:false,
                contentType: false,
                processData: false,
                data: formData,
                success: function (data) {
                    $('#preloader').css('display','none');
                    $('#status').css('display','none');
                    if (data["status"] == true) {
                        Swal.fire({
                            title: "",
                            text: data["data"],
                            type: "success",
                            showCancelButton: false,
                            confirmButtonColor: "#DD6B55",
                            confirmButtonText: "حسنا",
                            cancelButtonText: "الغاء",
                            closeOnConfirm: true,
                            closeOnCancel: true
                        });
                        getVideos(course_id);
                    } else {

                        
                        Swal.fire({
                            title: "",
                            text: data["data"],
                            type: "error",
                            showCancelButton: false,
                            confirmButtonColor: "#DD6B55",
                            confirmButtonText: "حسناً",
                            cancelButtonText: "إلغاء",
                            closeOnConfirm: true,
                            closeOnCancel: true
                        });



                    }

                }

            });





        });


    </script>
@endsection