@extends('site.layout.layout')

@section('url'){{URL::to('/')}}/university/{{ $data['university']->id }} @stop
@section('title'){{ $data['university']->title_ar }} @stop
@section('image'){{URL::to('/')}}/img/750x500/{{ $data['university']->photo }} @stop
@section('description'){{\App\Http\Helpers\Helpers::stringReplace($data['university']->details_ar)}} @stop

@section('css')
<style>


</style>
@endsection
@section('content')
<div class="ttm-page-title-row">
    <div class="ttm-page-title-row-inner ttm-textcolor-white">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-12">
                    <div class="page-title-heading">
                        <h2 class="title">{{ $data['university']->title_ar }}</h2>
                    </div>
                    <div class="breadcrumb-wrapper">
                        {{-- <span>
                            <a title="الرئيسية" href="{{URL::to('/')}}">{{ __('app.home') }}</a>
                        </span>
                        <span class="ttm-bread-sep">&nbsp;&gt;&nbsp;</span>
                        <span class="current"> الجامعات</span> --}}
                    </div>
                </div>
            </div>
        </div>
    </div>                    
</div>
<div class="site-main">
     <!--course-section_3-->
            <section class="ttm-row course-section_3 clearfix">
                <div class="container">
                    <div class="row">
                        @foreach ($data['courses'] as $item)

                                <div class="ttm-box-col-wrapper col-lg-4">
                                    <div class="featured-imagebox featured-imagebox-course">
                                        <div class="ttm-post-thumbnail featured-thumbnail"> 
                                            <img style="width:310px; height:280px; object-fit: cover;" class="img-fluid lazyload" src="{{URL::to('/')}}/uploads/{{$item->image}}" data-src="{{URL::to('/')}}/uploads/{{$item->image}}" alt="{{$item->title}}"> 
                                        </div>
                                        {{-- x470 --}}
                                        <div class="featured-content featured-content-post">
                                            <div class="featured-content-post-inner">
                                                <div class="post-title featured-title">
                                                    <h5>
                                                        <a href="{{URL::to('/')}}/cours/{{$item->id}}">
                                                            {{$item->title}}
                                                        </a>
                                                    </h5>
                                                </div>
                                                <div class="post-desc featured-desc">
                                                    {!!\App\Http\Helpers\Helpers::cutText($item->details,200,true)!!}
                                                    {{-- <p>هناك حقيقة مثبتة منذ زمن طويل وهي أن المحتوى المقروء لصفحة ما سيلهي القارئ عن التر...</p> --}}
                                                </div>
                                            </div>
                                            <div class="ttm-course-box-meta">
                                                <div class="ttm-enrolled">
                                                    <span class="ttm-count ttm-meta-line">
                                                        <i class="fa fa-files-o" aria-hidden="true"></i>
                                                        {{$item->videos_count}}
                                                    </span>
                                                </div>  
                                                <span class="ttm-lp-price">
                                                    <ins> {{$item->price}}  ر.س  </ins>
                                                </span> 
                                                

                                            </div>
                                        </div>
                                    </div>
                                </div>
                        @endforeach
                        {{-- لو اصبح هناك دورات مجانية  --}}
                        {{-- <span class="ttm-lp-price ttm-free-course"><ins> مجاناً</ins></span> --}}
                        {{-- لو اصبح هناك خصومات --}}
                        {{-- <span class="ttm-lp-price"><del>&#36;69.00</del><ins>&#36;45.00</ins></span> --}}
                    </div>
                    <div class="row" style="justify-content: center">
                        <div class="col text-center">
                            {!! $data['courses']->render() !!}
                        </div>
                    </div>
                    
                    
                </div>
            </section> 
        
</div>



@endsection
@section('js')

@endsection