@extends('admin.layout.master_layout')
@section('title')
   لوحة التحكم
@stop
@section('css')
<style> 
    
    .edit_data .status_season{
        display:none !important;
    }
    .check_category_div{
        display: none;
    }
    @media (min-width: 992px){
            .modal-lg {
                max-width: 1300px;
            }
        }
</style>
@endsection
@section('page-content')

<div class="m-grid__item m-grid__item--fluid  m-grid m-grid--ver-desktop m-grid--desktop m-page__container m-body">
    <div class="m-grid__item m-grid__item--fluid m-wrapper">
        <div class="m-subheader ">



			

            <div class="d-flex align-items-center" style="justify-content: space-between;">

                <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
                    <li class="m-nav__item m-nav__item--home">
                        <a href="#" class="m-nav__link m-nav__link--icon">
                            <i class="m-nav__link-icon la la-home"></i>
                        </a>
                    </li>
                    <li class="m-nav__item">
                        <a href="{{ route('admin.dashboard.view') }}" class="m-nav__link">
                            <span class="m-nav__link-text">الرئيسية</span>
                        </a>
                    </li>

                    <li class="m-nav__separator">-</li>
                    <li class="m-nav__item">
                        <a href="/system_constants" class="m-nav__link">
                            <span class="m-nav__link-text">ثوابت النظام</span>
                        </a>
                    </li>
                </ul>

                <div class="m-demo__preview  m-demo__preview--btn">
                    @can('add_system_constants')
                        <button type="button"  data-toggle="modal" data-target="#add_page" class="btn btn-danger m-btn m-btn--custom btnAddCustomer" style="line-height: 15px;"><i class="fa fa-plus"></i> إضافة ثابت</button>
                    @endcan  
                </div>

            </div>


           

        </div>

        <div class="m-content m-content pt-3">

            <div class="filter row mb-4 mt-2">
               
                <div class="col-md-3">
                    <input type="text" name="user_name_seach"  class="form-control user_name_seach" placeholder="اسم الثابت">
                </div>
                <div class="col-md-3">
                    <div class="form-valid">
                        <select name="type" class="form-control type" id="">
                            <option value="">اختر النوع</option>
                            @foreach($data['all_constant'] as $constant)
                                <option value="{{$constant->type}}">{{$constant->name}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                
            </div>


            <div class="">

                <div id="table-container">

                    @include('admin.system_constants.table-data')

                </div>

            </div>

        </div>

      

    </div>

</div>


@include('admin.system_constants.sub.add')
@include('admin.uploads.upload')

@stop

@section('js')
<script type="text/javascript">
    $('#activeValue').bootstrapSwitch('state', true, true);
    $('#check_category').bootstrapSwitch('state', true, true);
    
/********************************************************************************************************/
$('.user_name_seach').on('input',function(e){
    name =  $('.user_name_seach').val();
    if(name.length >= 3 || name == ''){
        var type = $('.type').val();
        var url = $(this).attr('href');
        getData(url,name,type);
    }
});
$('.type_constant').on('change',function(e){
    var type = $(this).val();
    if(type == 'city'){
        $('#add_page #addNewpageForm').find(".div_governorate").removeClass('d-none');
    }else{
        $('#add_page #addNewpageForm').find(".div_governorate").addClass('d-none');

    }

});




$('.type').on('change',function(e){
    name =  $('.user_name_seach').val();
    var type = $('.type').val();
    var url = $(this).attr('href');
    getData(url,name,type);
});

// $('#add_page .type_constant').on('change',function(e){

/***********************************************************************************************************************/
        $('body').on('click','.UpdateStats',function(){
            $(this).addClass('disabled');
            $('.loadImg').removeClass('hidden');
            $('.loadMSG').html('جاري تحديث الحالة');
            var thisTag = $(this);
            var id = $(this).data('id');
			$.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
            	url: "/admin/system_constants/UpdateStats",
                type: "POST",
                dataType: "JSON",
                data:{id:id},
                success: function(data) {
                    if(data["status"] == true){
						var url = $(this).attr('href');
                        var origin = $(location).attr("origin");
                                    var pathname = $(location).attr("pathname");
                                    var page = $('.pagination .active span').text();
                                    url = origin+pathname+'?page='+page;
						getData(url);
                    }else{
                        swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                    }
                }
            });
            $(thisTag).removeClass('disabled');
            $('.loadImg').addClass('hidden');
        });
</script>

<script>
$(document).on('click', '.pagination a',function(event)
        {
            event.preventDefault();
            $('li').removeClass('active');
            $(this).parent('li').addClass('active');
            var url = $(this).attr('href');
            var name =  $('.user_name_seach').val();
            var type = $('.type').val();
            getData(url,name,type);
        });
  
    function getData(url,name,type) {
        var name =  $('.user_name_seach').val();
        var type = $('.type').val();
        $('#load').show();
        $.ajax({
            url : url,
            data:{name:name,type:type}
        }).done(function (data) {
            $("#table-container").empty().html(data);
            $('#load').hide();
        });
    }
</script>
<script type="text/javascript">
    $(document).ready(function () {
        $(document).on('click', '.btnAddCustomer', function () {
            $('#addNewpageForm').removeClass('edit_data');
			$('#addNewpageForm').find(".name,.type_constant").val('');
			$('#addNewpageForm').find("select").val('');
            $('#addNewpageForm').find(".name_en").val('');
            $('#addNewpageForm').find(".governorate").val('');
            $('#add_page #addNewpageForm').find(".div_governorate").addClass('d-none');

            $('#addNewpageForm').find('.rowIdUpdate').val(0);
            $("#add_page").removeClass('edit_data');
            $('.modal-title').html('إضافة ثابت جديد');
            $('#activeValue').bootstrapSwitch('state', true, true);


        });

        $(document).on('click', '.updateDetails', function () {
			$('#addNewpageForm').find('.rowIdUpdate').val(0);
            $('#addNewpageForm').addClass('edit_data');
            $('.check_category_div').hide();
            $('#check_category').bootstrapSwitch('state', false, true);
            var id = $(this).data('id');
            $('.rowIdUpdate').val(id);
            $.ajax({
                url: "/admin/system_constants/edit",
                type: "get",
                dataType: "JSON",
                data: {
                    id: id
                },
                success: function(data){
					if(data['status'] == true){
						$(".name").val(data['data']['name_ar']);
                        $('#addNewpageForm').find(".name_en").val(data['data']['name_en']);
                        $(".type_constant").val(data['data']['type']);

                        if(data['data']['type'] == 'city'){
                            $('#add_page #addNewpageForm').find(".div_governorate").removeClass('d-none');
                            $('#addNewpageForm').find(".governorate").val(data['data']['value3']);
                        }else{
                            $('#add_page #addNewpageForm').find(".div_governorate").addClass('d-none');
                            $('#addNewpageForm').find(".governorate").val('');


                        }
					}
                },
                complete: function () {
                    $('#add_page').modal('show');
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    swal({title: 'حدث خطأ غير معروف، الرجاء المحاولة فيما بعد', type: "error"});
                }
            });

            $('.modal-title').html('تعديل بيانات');
            $('.btn_save_user').html('تعديل');

        });
        /*************************************************/
        $('.addNewpageForm').on('submit', function(e){
            e.preventDefault();
			var formData = new FormData(this);
            $('.loader_add_user').css('display', 'initial');
            setTimeout(function () {
                $('.btn_save_customer').removeClass('disabled');
                $('.loader_add_user').css('display', 'none');
            }, 30000);
            var id = $(".rowIdUpdate").val();
            if (id == 0) {
                $.ajax({
                    url: "/admin/system_constants/add",
                    type: "post",
					cache:false,
					contentType: false,
					processData: false,
                    data: formData,
                    success: function (data) {
                        if (data["status"] == true) {
                            swal({
                                title: "",
                                text: data["data"],
                                type: "success",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
                            var url = $(this).attr('href');
                            var origin = $(location).attr("origin");
                                    var pathname = $(location).attr("pathname");
                                    var page = $('.pagination .active span').text();
                                    url = origin+pathname+'?page='+page;
                            getData(url);
                            $('#addNewpageForm').find(".name_en").val('');
                            $('#addNewpageForm').find(".status").val('');
                            $('#addNewpageForm').find(".name").val('');
                            $('#addNewpageForm').find(".type_constant").val('');
                            $("#add_page").modal("hide");
                        } else {
                            swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });

                        }
                    }
                });
            } else {
				$.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
				});
                $.ajax({
                    url: "/admin/system_constants/update",
                    type: "POST",
                    dataType: "JSON",
					cache:false,
					contentType: false,
					processData: false,
                    data: formData,
                    success: function (data) {
                        if (data["status"] == true) {
                            swal({
                                title: "",
                                text: data["data"],
                                type: "success",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
							var url = $(this).attr('href');
                            var origin = $(location).attr("origin");
                            var pathname = $(location).attr("pathname");
                            var page = $('.pagination .active span').text();
                            url = origin+pathname+'?page='+page;
                            getData(url);
                            $('#addNewpageForm').find(".name_en").val('');
                            $('#addNewpageForm').find(".name").val('');
                            $('#addNewpageForm').find(".type_constant").val('');
							$('#addNewpageForm').find('.rowIdUpdate').val(0);
                            $("#add_page").modal("hide");
                        } else {
                            swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });

                        }
                    }
                });
            }
//	}
        });
        /****************************************************/
    });
/**************************************************************************************************************************/
	$(document).on('click','.delete',function(e){
		var id = $(this).data('id');
		Swal.fire({
				title: 'هل تريد حذف هذا العنصر ؟',
				text: "",
				type: 'warning',
				showCancelButton: true,
				confirmButtonColor: '#3085d6',
				cancelButtonColor: '#d33',
				confirmButtonText: 'حسنا',
				cancelButtonText: "الغاء",
			}).then((result) => {
				if (result.value) {
				$.ajaxSetup({
					headers: {
						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
					}
				});
				$.ajax({
                url: "/admin/system_constants/delete",
                type: "post",
                dataType: "JSON",
                data: {
                    id: id
                },
                success: function(data){
					if(data['status'] == true){
						Swal.fire(
						'تم الحذف بنجاح',
						'',
						'success'
						)
						var url = $(this).attr('href');
                        var origin = $(location).attr("origin");
                                    var pathname = $(location).attr("pathname");
                                    var page = $('.pagination .active span').text();
                                    url = origin+pathname+'?page='+page;
						getData(url);
					}else{
						swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسنا",
                                cancelButtonText: "الغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });
					}
                },
            });
				}
			})
	});
/************************************************************************** */
</script>
{{-- post_category --}}
<script>


</script>
@stop