@extends('admin.layout.master_layout')

@section('title')

   لوحة التحكم

@stop
@section('css')
<style> 
    
  
    @media (min-width: 992px){
            #modal_center .modal-lg {
                max-width: 1300px;
            }
        }
</style>
@endsection



@section('page-content')

<div class="m-grid__item m-grid__item--fluid  m-grid m-grid--ver-desktop m-grid--desktop m-page__container m-body">
    <div class="m-grid__item m-grid__item--fluid m-wrapper">
        <div class="m-subheader ">



			

            <div class="d-flex align-items-center" style="justify-content: space-between;">

                <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
                    <li class="m-nav__item m-nav__item--home">
                        <a href="#" class="m-nav__link m-nav__link--icon">
                            <i class="m-nav__link-icon la la-home"></i>
                        </a>
                    </li>
                    <li class="m-nav__item">
                        <a href="{{ route('admin.dashboard.view') }}" class="m-nav__link">
                            <span class="m-nav__link-text">الرئيسية</span>
                        </a>
                    </li>

                    <li class="m-nav__separator">-</li>
                    <li class="m-nav__item">
                        <a href="/admin/static_page" class="m-nav__link">
                            <span class="m-nav__link-text">الصفحات الثابتة</span>
                        </a>
                    </li>
                </ul>

                <div class="m-demo__preview  m-demo__preview--btn">
                    @can('add_page')
                        <button type="button"  data-toggle="modal" data-target="#add_page" class="btn btn-danger m-btn m-btn--custom btnAddCustomer" style="line-height: 15px;"><i class="fa fa-plus"></i> إضافة صفحة ثابتة</button>
                    @endcan  
                </div>

            </div>


           

        </div>

        <div class="m-content m-content pt-3">


            <div class="">

                <div id="table-container">

                    @include('admin.static_page.table-data')

                </div>

            </div>

        </div>

      

    </div>

</div>


@include('admin.static_page.sub.add')
@include('admin.uploads.upload')
@stop





@section('js')

<script type="text/javascript">



$('#activeValue').bootstrapSwitch('state', true, true);



function CKupdate(){

	for ( instance in CKEDITOR.instances )

		CKEDITOR.instances[instance].updateElement();

}

/***********************************************************************************************************************/

        $('body').on('click','.UpdateStats',function(){

            $(this).addClass('disabled');


            var thisTag = $(this);

            var id = $(this).data('id');

			$.ajaxSetup({

                headers: {

                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')

                }

            });

            $.ajax({

            	url: "/admin/static_page/UpdateStats",

                type: "POST",

                dataType: "JSON",

                data:{id:id},

                success: function(data) {

                    if(data["status"] == true){

                        var origin = $(location).attr("origin");
                                    var pathname = $(location).attr("pathname");
                                    var page = $('.pagination .active span').text();
                                    url = origin+pathname+'?page='+page;

						getData(url);

						window.history.pushState("", "", url); 

                    }

                }

            });

            $(thisTag).removeClass('disabled');

            $('.loadImg').addClass('hidden');

        });

</script>



<script>

$(document).on('click', '.mytable .pagination a',function(event)

        {

            event.preventDefault();

            $('li').removeClass('active');

            $(this).parent('li').addClass('active');

            var url = $(this).attr('href');

            getData(url);

            window.history.pushState("", "", url);

        });

  

    function getData(url) {
        $.ajax({
            url : url
        }).done(function (data) {

            $("#table-container").empty().html(data);

        });

    }

</script>

<script type="text/javascript">

    $(document).ready(function () {

        /*************************************************/
        function clear(){
            $('#addNewpageForm').find(".title_ar").val('');
			CKEDITOR.instances['details_ar'].setData('');
            $('#addNewpageForm').find(".title_en").val('');
			// CKEDITOR.instances['details_en'].setData('');
			$('#addNewpageForm').find(".slug").val('');
			$('#addNewpageForm').find(".image").val('');
            $('#addNewpageForm').find('.rowIdUpdate').val(0);
            $('#div_slug').removeClass('d-none')

            $('#activeValue').bootstrapSwitch('state', true, true);

            $('.img_review img').attr('src','/admin/assets/app/media/no_image.jpg');
        }
        $(document).on('click', '.btnAddCustomer', function () {
            clear();
            $('#add_page .modal-title').html.text('إضافة صفحة جديدة')
        });

        /*************************************************/

        $(document).on('click', '.updateDetails', function () {
            clear();
			$('#addNewpageForm').find('.rowIdUpdate').val(0);

            var id = $(this).data('id');

            $('.rowIdUpdate').val(id);

            $.ajax({

                url: "/admin/static_page/edit",

                type: "get",

                dataType: "JSON",

                data: {

                    id: id

                },

                success: function(data){

					if(data['status'] == true){
						$(".title_ar").val(data['data']['title_ar']);
						CKEDITOR.instances['details_ar'].setData(data['data']['details_ar']);
                        $(".title_en").val(data['data']['title_en']);
						// CKEDITOR.instances['details_en'].setData(data['data']['details_en']);
                        if(data['data']['delete_flag'] == 1){
                            
                            $('#div_slug').addClass('d-none')
                        }else{
                            $('#div_slug').removeClass('d-none')
  
                        }
						if(data['data']['status'] == 1){
							$('#activeValue').bootstrapSwitch('state', true, true);
						}else{
							$('#activeValue').bootstrapSwitch('state', false, true);
						}
						$(".slug").val(data['data']['slug']);
                        if(data['data']['photo']){
                            $('.img_review img').attr('src','/uploads/'+data['data']['photo']);
                        }

					}

                },

                complete: function () {

                    $('#add_page').modal('show');

                },

                error: function (jqXHR, textStatus, errorThrown) {

                    swal({title: 'حدث خطأ غير معروف، الرجاء المحاولة فيما بعد', type: "error"});

                }

            });



            $('#add_page .modal-title').html('تعديل بيانات');



        });

        /*************************************************/

        $('.addNewpageForm').on('submit', function(e){

            e.preventDefault();

            $('#loading').show();

			var formData = new FormData(this);

            $('.loader_add_user').css('display', 'initial');

            setTimeout(function () {

                $('.btn_save_customer').removeClass('disabled');

                $('.loader_add_user').css('display', 'none');

            }, 30000);

            var id = $(".rowIdUpdate").val();

            if (id == 0) {

                $.ajax({

                    url: "/admin/static_page/add",

                    type: "post",

					cache:false,

					contentType: false,

					processData: false,

                    data: formData,

                    success: function (data) {

                        $('#loading').hide();

                        if (data["status"] == true) {

                            swal({

                                title: "",

                                text: data["data"],

                                type: "success",

                                showCancelButton: false,

                                confirmButtonColor: "#DD6B55",

                                confirmButtonText: "حسنا",

                                cancelButtonText: "الغاء",

                                closeOnConfirm: true,

                                closeOnCancel: true

                            });

                            $("#add_page").modal("hide");
                            var url = $(this).attr('href');
                            var origin = $(location).attr("origin");
                                    var pathname = $(location).attr("pathname");
                                    var page = $('.pagination .active span').text();
                                    url = origin+pathname+'?page='+page;
                            getData(url);
                            clear();


                        } else {

                           
                            swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسناً",
                                cancelButtonText: "إلغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });



                        }

                    }

                });

            } else {

				$.ajaxSetup({

                headers: {

                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')

					}

				});

                $.ajax({

                    url: "/admin/static_page/update",

                    type: "POST",

                    dataType: "JSON",

					cache:false,

					contentType: false,

					processData: false,

                    data: formData,

                    success: function (data) {

                        $('#loading').hide();

                        if (data["status"] == true) {

                            swal({

                                title: "",

                                text: data["data"],

                                type: "success",

                                showCancelButton: false,

                                confirmButtonColor: "#DD6B55",

                                confirmButtonText: "حسنا",

                                cancelButtonText: "الغاء",

                                closeOnConfirm: true,

                                closeOnCancel: true

                            });

                            clear();

                            $("#add_page").modal("hide");

                            var url = $(this).attr('href');
                            var origin = $(location).attr("origin");
                                    var pathname = $(location).attr("pathname");
                                    var page = $('.pagination .active span').text();
                                    url = origin+pathname+'?page='+page;
                            getData(url);

                            // window.history.pushState("", "", url); 

                        } else {

                            swal({
                                title: "",
                                text: data["data"],
                                type: "error",
                                showCancelButton: false,
                                confirmButtonColor: "#DD6B55",
                                confirmButtonText: "حسناً",
                                cancelButtonText: "إلغاء",
                                closeOnConfirm: true,
                                closeOnCancel: true
                            });



                        }

                    }

                });

            }

//	}

        });

        /****************************************************/

    });



	$(document).on('click','.delete',function(e){

		var id = $(this).data('id');

		Swal.fire({

				title: 'هل تريد حذف هذا العنصر ؟',

				text: "",

				type: 'warning',

				showCancelButton: true,

				confirmButtonColor: '#3085d6',

				cancelButtonColor: '#d33',

				confirmButtonText: 'حسنا',

				cancelButtonText: "الغاء",

			}).then((result) => {

				if (result.value) {

				$.ajaxSetup({

					headers: {

						'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')

					}

				});

				$.ajax({

                url: "/admin/static_page/delete",

                type: "post",

                dataType: "JSON",

                data: {

                    id: id

                },

                success: function(data){

					if(data['status'] == true){

						Swal.fire(

						'تم الحذف بنجاح',

						'',

						'success'

						)

						var url = $(this).attr('href');
                        var origin = $(location).attr("origin");
                        var pathname = $(location).attr("pathname");
                        var page = $('.pagination .active span').text();
                        url = origin+pathname+'?page='+page;
						getData(url);

						window.history.pushState("", "", url); 

					}else{

						swal({

                                title: "",

                                text: data["data"],

                                type: "error",

                                showCancelButton: false,

                                confirmButtonColor: "#DD6B55",

                                confirmButtonText: "حسنا",

                                cancelButtonText: "الغاء",

                                closeOnConfirm: true,

                                closeOnCancel: true

                            });

					}

                },

            });

				}

			})

	});

</script>

@stop