@extends('admin.layout.master_layout')
@section('title')
   لوحة التحكم
@stop
@section('css')
    <style>
            .hide{
                display:none;
            }
            .img-profile,#img-selected{
                width: 140px;
                background: #ddd;
                height: 140px;
                border-radius: 50%;
            }
            .input-file{
                visibility: hidden;
            }
            .input-file-trigger{
                position: absolute;
                top: 45%;
            }
            .form-submit{
                position: absolute;
                top: 45%;
            }
            .photo{
                text-align:center;
            }
            .fade:not(.show) {
                opacity: 0;
                display: none;
            }
    </style>
     <style type="text/css">
        /* .bootstrap-tagsinput .tag {
          margin-right: 2px;
          color: white !important;
          background-color: #0d6efd;
          padding: 0.2rem;
        } */
      </style>
          
        <link href="https://unpkg.com/@yaireo/tagify/dist/tagify.css" rel="stylesheet" type="text/css" />

@endsection
@section('page-content')
<div class="m-grid__item m-grid__item--fluid  m-grid m-grid--ver-desktop m-grid--desktop m-page__container m-body">
    <div class="m-grid__item m-grid__item--fluid m-wrapper">
        <div class="m-subheader ">



			

            <div class="d-flex align-items-center" style="justify-content: space-between;">

                <ul class="m-subheader__breadcrumbs m-nav m-nav--inline">
                    <li class="m-nav__item m-nav__item--home">
                        <a href="#" class="m-nav__link m-nav__link--icon">
                            <i class="m-nav__link-icon la la-home"></i>
                        </a>
                    </li>
                    <li class="m-nav__item">
                        <a href="{{ route('admin.dashboard.view') }}" class="m-nav__link">
                            <span class="m-nav__link-text">الرئيسية</span>
                        </a>
                    </li>

                    <li class="m-nav__separator">-</li>
                    <li class="m-nav__item">
                        <a href="{{ route('admin.setting.index') }}" class="m-nav__link">
                            <span class="m-nav__link-text">الإعدادات العامة</span>
                        </a>
                    </li>
                </ul>


            </div>


           

        </div>

        <div class="m-content m-content pt-3">

          

            <div class="">

                <div class="m-portlet__body">
                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                    @can('setting')
                    <li class="nav-item">
                        <a class="nav-link active" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">إعدادات العامة</a>
                    </li>
                    @endcan
                    <li class="nav-item">
                        <a class="nav-link" id="home1-tab" data-toggle="tab" href="#home1" role="tab" aria-controls="home1" aria-selected="true">ميسر  </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link " id="home2-tab" data-toggle="tab" href="#home2" role="tab" aria-controls="home2" aria-selected="true"> مسجات </a>
                    </li>
                    </ul>
                    <div class="tab-content" id="myTabContent">
                    @can('setting')
                    
                    <form class="settingForm" id="settingForm" action="" method="post">
                        @csrf
                        <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                            <div class="form-group m-form__group row">
                                    <div class="col-md-3 mb-3">
                                        <label>عنوان الموقع  <span class="required">*</span></label>
                                        <div class="form-valid">
                                            <input type="text" name="title_ar" value="{{$title = $data['setting']->name_ar ?? ''}}" class="form-control name_ar" placeholder="عنوان الموقع باللغة العربية">
                                        </div>
                                    </div>
                                    
                                    
                                    <div class="col-md-3 mb-3">
                                        <label>كلمات دلالية  <span class="required">*</span></label>
                                        <div class="form-valid">
                                            <input type="text" name="key_words" value="{{$title = $data['setting']->key_words_ar ?? ''}}" class="form-control key_words" placeholder="كلمات دلالية باللغة العربية">
                                        </div>
                                    </div>

                                    {{-- <div class="col-md-3 mb-3">
                                        <label>عنوان الموقع باللغة الانجليزية<span class="required">*</span></label>
                                        <div class="form-valid">
                                            <input type="text" name="title_en" value="{{$title = $data['setting']->name_en ?? ''}}" class="form-control name_en" placeholder="عنوان الموقع باللغة الانجليزية">
                                        </div>
                                    </div> --}}
                                    
                                    
                                    {{-- <div class="col-md-3 mb-3">
                                        <label>كلمات دلالية باللغة الانجليزية<span class="required">*</span></label>
                                        <div class="form-valid">
                                            <input type="text" name="key_words_en" value="{{$title = $data['setting']->key_words_en ?? ''}}" class="form-control key_words_en" placeholder="كلمات دلالية باللغة الانجليزية">
                                        </div>
                                    </div>
                                    --}}
                                    
                                    <div class="col-md-3 mb-3">
                                        <label>البريد الالكتروني<span class="required">*</span></label>
                                        <div class="form-valid">
                                            <input type="email" name="email" value="{{$title = $data['setting']->email ?? ''}}" class="form-control email" placeholder="البريد الالكتروني">
                                        </div>
                                    </div>
        
                                    <div class="col-md-3 mb-3">
                                        <label>الجوال</label>
                                        <div class="form-valid">
                                            <input type="text" value="{{$title = $data['setting']->mobile ?? ''}}" name="mobile" class="form-control mobile" placeholder="الجوال">
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-lg-6 mb-6">
                                        <label>وصف الموقع   <span class="required">*</span></label>
                                        <textarea name="description" class="description form-control" id="" cols="30" rows="5" placeholder="وصف الموقع باللغة العربية">{{$title = $data['setting']->description_ar ?? ''}}</textarea>
                                    </div>

                                    {{-- <div class="col-md-3 col-lg-3 mb-3">
                                        <label>وصف الموقع باللغة الانجليزية <span class="required">*</span></label>
                                        <textarea name="description_en" class="description_en form-control" id="" cols="30" rows="5" placeholder="وصف الموقع باللغة الانجليزية">{{$title = $data['setting']->description_en ?? ''}}</textarea>
                                    </div> --}}

                                </div> 

                        
                            </div>
                            <div class="tab-pane fade  " id="home1" role="tabpanel" aria-labelledby="home1-tab">
                                <div class="form-group m-form__group row">
                                    <div class="col-md-4">
                                        <label> Moyasar Key  <span class="required">*</span></label>
                                        <div class="form-valid">
                                            <input type="text" name="moyasar_key" value="{{$title = $data['setting']->moyasar_key ?? ''}}" class="form-control moyasar_key" placeholder="   ">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade  " id="home2" role="tabpanel" aria-labelledby="home2-tab">

                                <div class="form-group m-form__group row">
                                    <div class="col-md-4 mb-3">
                                        <label>User Name  <span class="required">*</span></label>
                                        <div class="form-valid">
                                            <input type="text" name="userName" value="{{$title = $data['setting']->userName ?? ''}}" class="form-control userName" placeholder="   ">
                                        </div>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label>User Sender  <span class="required">*</span></label>
                                        <div class="form-valid">
                                            <input type="text" name="userSender" value="{{$title = $data['setting']->userSender ?? ''}}" class="form-control userSender" placeholder="   ">
                                        </div>
                                    </div>
                                    <div class="col-md-4 mb-3">
                                        <label>Api Key  <span class="required">*</span></label>
                                        <div class="form-valid">
                                            <input type="text" name="apiKey" value="{{$title = $data['setting']->apiKey ?? ''}}" class="form-control apiKey" placeholder="   ">
                                        </div>
                                    </div>
                                </div>

                            </div>
                            <div class="modal-footer">
                                @can('update_setting')
                                <button type="submit" class="btn btn-primary btn_save_page">حفظ</button>
                                @endcan
                            </div>
                        </form>
                    
                    @endcan

                    <!-- ////////////////////////////////// END TAB ////////////////////////////////// -->
                </div>
        
            </div>

            </div>

        </div>

      

    </div>

</div>



@stop
@section('js')
<script src="https://unpkg.com/@yaireo/tagify"></script>
<script src="https://unpkg.com/@yaireo/tagify@3.1.0/dist/tagify.polyfills.min.js"></script>
<script>
    // $(document).ready(function(e){
    //     getData();
    // });
        var input = document.querySelector('input[name=key_words]');
        // initialize Tagify on the above input node reference
        new Tagify(input)
</script>
<script>
            $('#settingForm').on('submit', function(e){
            e.preventDefault();
            var formData = new FormData(this);
                $.ajax({
                    url: '/admin/setting/update',
                    dataType:'json',
                    type: 'POST',
                    delay:250,
                    data: formData,
                    async: false,
                    success: function (data) {
                        if (data["status"] == true) {
                                Swal.fire(
                                data['message'],
                                '',
                                'success'
                                );
                                $('.img-profile').attr("src", "/uploads/"+data['data']['logo']);
                                $('.img-profile').show();
                                $('#img-selected').hide();
                                $('.form-submit').addClass('hide');
                                $('.input-file-container').removeClass('hide');
                        }else {
                            if(data['data_validator']!=null){
                                var dt = '<ul>';
                                    $.each(data["data_validator"], function (key, value) {
                                        dt = dt + '<li>' + value + '</li>';
                                    })
                                    dt =dt+ '</ul>';
                                swal({
                                    title: "",
                                    text: data["data"],
                                    type: "error",
                                    html:dt,
                                    showCancelButton: false,
                                    confirmButtonColor: "#DD6B55",
                                    confirmButtonText: "{{__('text.ok')}}",
                                    cancelButtonText: "{{__('text.cancel')}}",
                                    closeOnConfirm: true,
                                    closeOnCancel: true
                                });
                            }else{
                                swal({
                                    title: "",
                                    text: data['message'],
                                    type: "error",
                                    showCancelButton: false,
                                    confirmButtonColor: "#DD6B55",
                                    confirmButtonText: "{{__('text.ok')}}",
                                    cancelButtonText: "{{__('text.cancel')}}",
                                    closeOnConfirm: true,
                                    closeOnCancel: true
                                });
                            }
                            // Swal.fire({
                            //     type: 'error',
                            //     title: 'عذرا',
                            //     text: data['message']
                            // })
                        }
                    },
                    cache: false,
                    contentType: false,
                    processData: false
                });
            });
</script>
<script>
function readURL(input) {
        if (input.files && input.files[0]) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('#img-selected').attr('src', e.target.result);
                $('.img-profile').hide();
                $('#img-selected').show();
                $('.form-submit').removeClass('hide');
                $('.input-file-container').addClass('hide');
            };
            reader.readAsDataURL(input.files[0]);
        }
    }
 $('.back').on('click',function(e){
    e.preventDefault();
    $('.img-profile').show();
    $('#img-selected').hide();
    $('.form-submit').addClass('hide');
    $('.input-file-container').removeClass('hide');
 })   
</script>
@stop