<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Setting extends Model
{
    use SoftDeletes;
    protected $table = 'settings';
    protected $fillable = ['name_ar', 'email', 'mobile', 'logo', 'user_id', 'description', 'key_words', 'moyasar_key', 'userName', 'userSender', 'apiKey'];

    public function getsetting($id)
    {
        return $this->find($id);
    }

    public static function getSettingByName($name)
    {
        return static::select($name)->first()[$name];
    }

    public function setting($obj, $title_ar, $email, $mobile1, $description, $key_words, $name_en, $description_en, $key_words_en, $moyasar_key, $userName, $userSender, $apiKey)
    {
        $obj->name_ar = $title_ar;
        $obj->description_ar = $description;
        $obj->key_words_ar = $key_words;
        $obj->name_en = $name_en;
        $obj->description_en = $description_en;
        $obj->key_words_en = $key_words_en;
        $obj->email = $email;
        $obj->mobile = $mobile1;
        $obj->moyasar_key = $moyasar_key;
        $obj->userName = $userName;
        $obj->userSender = $userSender;
        $obj->apiKey = $apiKey;
        $obj->save();
        return $obj;
    }


    public function getImageAttribute($img)
    {
        if ($img) {
            return asset('uploads/' . $img);
        } else {
            return asset('uploads/logo.png');
        }
    }
}
