<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Course extends Model
{
    use SoftDeletes;
    protected $table = 'courses';

    public function category()
    {
        return $this->belongsTo(System_Constants::class, 'category_id', 'value')->where('type', 'courses_category');
    }

    public function trainer()
    {
        return $this->belongsTo(Trainers::class, 'trainers', 'id');
    }

    public function universitie()
    {
        return $this->belongsTo(Universities::class, 'universities', 'id');
    }

    public function videos()
    {
        return $this->hasMany(Video::class, 'course_id', 'id');
    }
}
