<?php



namespace App\Http\Controllers\Site;



use App\Models\User;

use App\Models\static_page;

use App\Models\Posts;
use App\Models\Sample;
use App\Models\Library;
use App\Models\Trainings;
use App\Models\Tag;

use App\Models\Adv;

use App\Models\PostsHome;

use Illuminate\Http\Request;

use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Facades\Hash;

use Illuminate\Support\Facades\Session;

use Illuminate\Support\Facades\Validator;

use App\Models\Messages;

use App\Models\Albums;

use App\Models\Videos;

use App\Models\Tmp;

use App\Models\Setting;

use Carbon\Carbon;

use App\Mail\ContactUs;
use App\Mail\ResearchLettersAndPapersEmail;
use App\Mail\SuggestionsIdeasEmail;
use App\Models\AboutSite;
use App\Models\AlbumsImages;
use App\Models\Animals;
use App\Models\AttachmentsSuggestionsIdeas;
use App\Models\Client;
use App\Models\Course;
use App\Models\CropsAndPlants;
use App\Models\Diseases;
use App\Models\Donation;
use App\Models\Email;
use App\Models\Engineers;
use App\Models\FoodIndustrial;
use App\Models\HarvestDates;
use App\Models\Institution;
use App\Models\MyCourses;
use App\Models\NewsTags;
use App\Models\PlantingDates;
use App\Models\Polls;
use App\Models\Poultry;
use App\Models\Research;
use App\Models\ResearchLettersAndPapers;
use App\Models\ResearchTags;
use App\Models\Notifications;
use App\Models\SectorSuggestionsIdeas;
use App\Models\Slider;
use App\Models\Statistics;
use App\Models\StatusResearchLettersAndPapers;
use App\Models\SuggestionsIdeas;
use App\Models\System_Constants;
use App\Models\Trainers;
use App\Models\Universities;
use App\Models\Video;
use App\Models\WorkshopsPanelDiscussions;
use DB;

class HomeController extends BaseController

{

    public function __construct()
    {

        parent::__construct();
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////////////



    public function index()
    {
        $lang            =   'ar';
        $lang_val        =    ['ar' => 1, 'en' => 2];

        $data['setting'] = \App\Models\Setting::where('id', 1)->first(["name_" . $lang . " as name", "description_" . $lang . " as description"]);

        $data['slider'] = Slider::where('status', 1)
            ->select('id', "title_" . $lang . " as title", "details_" . $lang . " as details", 'status', 'photo')
            ->orderBy('id', 'desc')->first();

        $data['universities'] = Universities::where('status', 1)->orderBy('id', 'asc')->take(5)->get();

        $data['aboutus'] = static_page::where('slug', 'aboutus')->first(['id', "title_" . $lang . " as title", "details_" . $lang . " as details", 'photo', 'slug']);

        $data['statistics'] = Statistics::where('status', 1)
            ->select('id', "title_" . $lang . " as title", "number", 'status')
            ->orderBy('id', 'desc')->get();

        return view('site.index', compact(['data']));
    }

    public function static($url)
    {

        $lang            =   'ar';
        $lang_val        =    ['ar' => 1, 'en' => 2];

        $data['static'] = static_page::where('status', 1)->where('slug', $url)->get(["title_" . $lang . " as title", "details_" . $lang . " as details", 'photo'])->first();
        $setting = \App\Models\Setting::where('id', 1)->first(["name_ar as name", "description_ar as description", 'mobile', 'email']);
        if (!$data['static']) {
            abort(404);
        }
        return view('site.static', compact('data', 'url', 'setting'));
    }


    public function Universities()
    {

        $lang            =   'ar';
        $lang_val        =    ['ar' => 1, 'en' => 2];

        $data['universities'] = Universities::where('status', 1)->orderBy('id', 'asc')->get();

        $setting = \App\Models\Setting::where('id', 1)->first(["name_ar as name", "description_ar as description", 'mobile', 'email']);

        return view('site.universities', compact('data', 'setting'));
    }

    public function university($id)
    {
        // return 123;

        $lang            =   'ar';
        $lang_val        =    ['ar' => 1, 'en' => 2];

        $data['university'] = Universities::where('status', 1)->where('id', $id)->first();

        $data['courses'] = Course::where('universities', $id)
            ->where('status', 1)
            ->where('lang', $lang_val[$lang])
            ->with('category', 'trainer', 'universitie')
            ->orderBy('id', 'desc')
            ->paginate(12);
        foreach ($data['courses'] as  $value) {
            $videos = Video::where('course_id', $value->id)->count();
            $value['videos_count'] = $videos;
        }
        // return $data;

        $setting = \App\Models\Setting::where('id', 1)->first(["name_ar as name", "description_ar as description", 'mobile', 'email']);

        return view('site.course_university', compact('data', 'setting'));
    }



    public function registration()
    {

        $lang            =   'ar';
        $lang_val        =    ['ar' => 1, 'en' => 2];

        $data['static'] = static_page::where('status', 1)->where('slug', 'registration')->get(["title_" . $lang . " as title", "details_" . $lang . " as details", 'photo'])->first();
        $system = new System_Constants();
        $data['Degree'] = $system->constants('Degree');
        $setting = \App\Models\Setting::where('id', 1)->first(["name_ar as name", "description_ar as description", 'mobile', 'email']);

        return view('site.registration', compact('data', 'setting'));
    }


    public function add_student(Request $request)
    {

        $name = $request->get('name');
        $email = $request->get('email');
        $mobile = $request->get('mobile');
        $dob = $request->get('dob');
        $password = $request->get('password');
        $degree = $request->get('degree');

        $rules = [
            'name' => 'required',
            'email' => 'required',
            'mobile' => 'required',
            'dob' => 'required',
            'password' => 'required',
            'degree' => 'required',
        ];

        $messages = [
            'name.required' => 'الاسم بالكامل مطلوب',
            'email.required' => 'البريد الالكتروني مطلوب ',
            'mobile.required' => ' رقم الجوال مطلوب ',
            'dob.required' => 'تاريخ الميلاد مطلوب ',
            'password.required' => 'كلمة المرور مطلوبة ',
            'degree.required' => 'المرحلة الدراسية مطلوبة ',
        ];

        $validator = \Validator::make(
            [
                'name' => $name,
                'email' => $email,
                'mobile' => $mobile,
                'dob' => $dob,
                'password' => $password,
                'degree' => $degree,
            ],

            $rules,
            $messages
        );

        if ($validator->fails()) {
            return response()->json(['status' => false, 'data_validator' => $validator->messages()]);
        }

        $clients = Client::where('email', $email)->first();
        if ($clients) {
            return response()->json(['status' => false, 'data' => trans('app.email_address_already')]);
        }


        $clients1 = Client::where('mobile', $mobile)->first();
        if ($clients1) {
            return response()->json(['status' => false, 'data' => trans('app.mobile_already')]);
        }


        $clients2 = Trainers::where('email', $email)->first();
        if ($clients2) {
            return response()->json(['status' => false, 'data' => trans('app.email_address_already')]);
        }

        $clients3 = Trainers::where('mobile', $mobile)->first();
        if ($clients3) {
            return response()->json(['status' => false, 'data' => trans('app.mobile_already')]);
        }

        // $data = @file_get_contents('https://www.google.com/recaptcha/api/siteverify?secret=6LcPvxATAAAAAKLsvWmP1A3D2Bx9zRMSuB_-f_tj&response=' . $_POST['g-recaptcha-response']);

        // $data = json_decode($data);

        // if ($data->success) {

        DB::beginTransaction();
        try {

            $client = new Client();
            $client->name = $name;
            $client->email = $email;
            $client->mobile = $mobile;
            $client->dob = $dob;
            $client->password = \Hash::make($password);
            $client->degree = $degree;
            $client->img = 'profile.png';
            // $client->gender = '';

            $saved = $client->save();
            // \Auth::guard('clients')->logout();
            // \Auth::guard('trainers')->logout();


            DB::commit();
            // $field = 'mobile';
            // $remember_token = '';
            // $cl[$field] = $client->mobile;
            // $cl['password'] = $password;
            // if (\Auth::guard('clients')->attempt($cl, $remember_token)) {
            return response()->json(['status' => true, 'data' => trans('app.Registration_completed')]);
            // }
        } catch (\Exception $e) {
            DB::rollback();
            // return $e;
        }
        return response()->json(['status' => false, 'data' => ' حدث خطأ يرجى المحاولة مرة اخرى ']);

        // $setting = Setting::where('id', 1)->first('email');
        // if ($setting != '') {
        //     \Mail::to($setting->email)->send(new ContactUs($request));
        // }
        // }



    }


    public function add_trainer(Request $request)
    {

        $name = $request->get('name');
        $email = $request->get('email');
        $mobile = $request->get('mobile');
        $dob = $request->get('dob');
        $password = $request->get('password');
        $note = $request->get('note');

        $rules = [
            'name' => 'required',
            'email' => 'required',
            'mobile' => 'required',
            'dob' => 'required',
            'password' => 'required',
            'note' => 'required',
        ];

        $messages = [
            'name.required' => 'الاسم بالكامل مطلوب',
            'email.required' => 'البريد الالكتروني مطلوب ',
            'mobile.required' => ' رقم الجوال مطلوب ',
            'dob.required' => 'تاريخ الميلاد مطلوب ',
            'password.required' => 'كلمة المرور مطلوبة ',
            'note.required' => '  نبذة عنك مطلوبة  ',
        ];

        $validator = \Validator::make(
            [
                'name' => $name,
                'email' => $email,
                'mobile' => $mobile,
                'dob' => $dob,
                'password' => $password,
                'note' => $note,
            ],
            $rules,
            $messages
        );

        if ($validator->fails()) {
            return response()->json(['status' => false, 'data_validator' => $validator->messages()]);
        }

        $clients = Trainers::where('email', $email)->first();
        if ($clients) {
            return response()->json(['status' => false, 'data' => trans('app.email_address_already')]);
        }

        $clients1 = Trainers::where('mobile', $mobile)->first();
        if ($clients1) {
            return response()->json(['status' => false, 'data' => trans('app.mobile_already')]);
        }

        $clients2 = Client::where('email', $email)->first();
        if ($clients2) {
            return response()->json(['status' => false, 'data' => trans('app.email_address_already')]);
        }

        $clients3 = Client::where('mobile', $mobile)->first();
        if ($clients3) {
            return response()->json(['status' => false, 'data' => trans('app.mobile_already')]);
        }

        // $data = @file_get_contents('https://www.google.com/recaptcha/api/siteverify?secret=6LcPvxATAAAAAKLsvWmP1A3D2Bx9zRMSuB_-f_tj&response=' . $_POST['g-recaptcha-response']);

        // $data = json_decode($data);

        // if ($data->success) {

        DB::beginTransaction();
        try {

            $client = new Trainers();
            $client->title_ar = $name;
            $client->email = $email;
            $client->mobile = $mobile;
            $client->dob = $dob;
            $client->password = \Hash::make($password);
            $client->pass = $password;
            $client->details_ar = $note;
            $client->photo = 'profile.png';
            $client->status = 1;
            $saved = $client->save();

            // \Auth::guard('clients')->logout();
            // \Auth::guard('trainers')->logout();

            // $field = 'mobile';
            // $remember_token = '';
            // $cl[$field] = $client->mobile;
            // $cl['password'] = $password;
            // if (\Auth::guard('trainers')->attempt($cl, $remember_token)) {
            DB::commit();
            return response()->json(['status' => true, 'data' => trans('app.Registration_completed')]);
            // }
            // DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            // return  $e->getMessage();
        }
        return response()->json(['status' => false, 'data' => ' حدث خطأ يرجى المحاولة مرة اخرى ']);

        // $setting = Setting::where('id', 1)->first('email');
        // if ($setting != '') {
        //     \Mail::to($setting->email)->send(new ContactUs($request));
        // }
        // }


    }
    public function contacts(Request $request)
    {

        $name = $request->get('name');

        $email = $request->get('email');

        $mobile = $request->get('mobile');

        $details = $request->get('text');





        $rules = [

            'name' => 'required',

            'email' => 'required',

            'mobile' => 'required',

            'text' => 'required',

        ];



        $messages = [

            'name.required' => trans('app.name_required'),

            'email.required' => trans('app.email_required'),

            'mobile.required' => trans('app.mobile_required'),

            'text.required' => trans('app.text_required'),

        ];



        $validator = \Validator::make(
            [

                'name' => $name,

                'email' => $email,

                'mobile' => $mobile,

                'text' => $details,

            ],

            $rules,

            $messages
        );



        if ($validator->fails()) {
            return response()->json(['status' => false, 'data_validator' => $validator->messages()]);
        }


        $message = new Messages();

        $message->name = $name;

        $message->email = $email;

        $message->mobile = $mobile;

        $message->details = $details;

        $saved = $message->save();

        if (!$saved) {

            return response()->json(['status' => false, 'data' => trans('app.whoops')]);
        }



        // $setting = Setting::where('id', 1)->first('email');

        // if ($setting != '') {

        //     \Mail::to($setting->email)->send(new ContactUs($request));
        // }



        return response()->json(['status' => true, 'data' => trans('app.success')]);
    }

    public function cours($id)
    {

        $lang            =   'ar';
        $lang_val        =    ['ar' => 1, 'en' => 2];

        $setting = \App\Models\Setting::where('id', 1)->first(["name_" . $lang . " as name", "description_" . $lang . " as description"]);


        $data['courses'] = Course::where('lang', $lang_val[$lang])
            ->with('category', 'trainer', 'universitie')
            ->where('status', 1)
            ->where('id', $id)
            ->orderBy('id', 'desc')->first();
        if (!$data['courses']) {
            abort(404);
        }

        $videos = Video::where('course_id', $data['courses']->id)->count();
        $data['courses']['videos_count'] = $videos;
        $data['videos'] = Video::where('course_id', $data['courses']->id)->where('type', 1)->get();
        $data['pdf'] = Video::where('course_id', $data['courses']->id)->where('type', 2)->get();
        $data['flip'] = Video::where('course_id', $data['courses']->id)->where('type', 3)->get();

        $data['all_data_courses'] = Video::where('course_id', $data['courses']->id)
            ->orderBy('id', 'asc')
            ->get();

        $data['courses']['registered'] = 0;

        if (Auth::guard('clients')->check()) {
            $client = (Auth::guard('clients')->user()->id);
            $favorites = MyCourses::where('courses_id', $id)->where('client_id', $client)->first();
            if ($favorites) {
                $data['courses']['registered'] = 1;
            }
        }
        $data['other_courses'] = Course::where('lang', $lang_val[$lang])
            ->where('id', '!=', $id)
            ->with('category', 'trainer', 'universitie')
            ->where('status', 1)
            ->orderBy('id', 'desc')
            ->take(4)
            ->get();


        $data['universities'] = Universities::where('status', 1)->orderBy('id', 'asc')->get();

        $data['trainer'] = Trainers::where('status', 1)->where('universities', $data['courses']->universities)->orderBy('id', 'asc')->get();

        $data['rating'] = MyCourses::where('my_courses.courses_id', $id)
            ->whereNotNull('my_courses.stars_no')
            ->leftJoin('clients as c', function ($join) {
                $join->on('c.id', '=', 'my_courses.client_id')->whereNull('c.deleted_at');
            })
            ->orderBy('my_courses.id', 'asc')
            ->select('my_courses.*', 'c.name as client_name', 'c.img as client_img')
            ->get();

        // return $data;

        return view('site.courses_single', compact('data', 'setting'));
    }



    public function TrainingCourses()
    {
        // return 123;

        $lang            =   'ar';
        $lang_val        =    ['ar' => 1, 'en' => 2];


        $data['courses'] = Course::where('lang', $lang_val[$lang])
            ->with('category', 'trainer', 'universitie')
            ->orderBy('id', 'desc')
            ->where('status', 1)
            ->paginate(12);
        foreach ($data['courses'] as  $value) {
            $videos = Video::where('course_id', $value->id)->count();
            $value['videos_count'] = $videos;
        }
        $data['universities'] = Universities::where('status', 1)->orderBy('id', 'asc')->get();
        // return $data;

        $setting = \App\Models\Setting::where('id', 1)->first(["name_ar as name", "description_ar as description", 'mobile', 'email']);

        return view('site.training_courses', compact('data', 'setting'));
    }


    public function getDataUniversities(Request $request)
    {
        $lang            =   'ar';
        $lang_val        =    ['ar' => 1, 'en' => 2];
        $id = $request->get('id');
        if ($id == null) {

            $data['courses'] = Course::where('lang', $lang_val[$lang])
                ->with('category', 'trainer', 'universitie')
                ->orderBy('id', 'desc')
                ->paginate(12);
            foreach ($data['courses'] as  $value) {
                $videos = Video::where('course_id', $value->id)->count();
                $value['videos_count'] = $videos;
            }

            $options_trainer = '';
            $options_trainer .= '<option value=""> اختر الجامعة</option>';
        } else {

            $data['courses'] = Course::where('lang', $lang_val[$lang])
                ->where('universities', $id)
                ->with('category', 'trainer', 'universitie')
                ->orderBy('id', 'desc')
                ->paginate(12);
            foreach ($data['courses'] as  $value) {
                $videos = Video::where('course_id', $value->id)->count();
                $value['videos_count'] = $videos;
            }

            $data['trainer'] = Trainers::where('status', 1)->where('universities', $id)->orderBy('id', 'asc')->get();
            $options_trainer = '';
            $options_trainer .= '<option value=""> اختر المدرب</option>';
            foreach ($data['trainer'] as $constant) {
                $options_trainer .= '<option value="' . $constant->id . '">' . $constant->title_ar . '</option>';
            }
        }


        $options = view('site.sub.table_training_courses', compact('data'))->render();

        return response()->json(['status' => true, 'data' => $options, 'options_trainer' => $options_trainer]);
    }

    // 
    public function getDataTrainer(Request $request)
    {
        $lang            =   'ar';
        $lang_val        =    ['ar' => 1, 'en' => 2];
        $id = $request->get('id');
        $universities = $request->get('universities');
        if ($id == null) {

            $data['courses'] = Course::where('lang', $lang_val[$lang])
                ->where('universities', $universities)
                ->with('category', 'trainer', 'universitie')
                ->orderBy('id', 'desc')
                ->paginate(12);
            foreach ($data['courses'] as  $value) {
                $videos = Video::where('course_id', $value->id)->count();
                $value['videos_count'] = $videos;
            }
        } else {
            $data['courses'] = Course::where('lang', $lang_val[$lang])
                ->where('universities', $universities)
                ->where('trainers', $id)
                ->with('category', 'trainer', 'universitie')
                ->orderBy('id', 'desc')
                ->paginate(12);
            foreach ($data['courses'] as  $value) {
                $videos = Video::where('course_id', $value->id)->count();
                $value['videos_count'] = $videos;
            }
        }
        // return 123;
        $options = view('site.sub.table_training_courses', compact('data'))->render();

        return response()->json(['status' => true, 'data' => $options]);
    }

    public function trainer($id)
    {
        $lang            =   'ar';
        $lang_val        =    ['ar' => 1, 'en' => 2];

        $setting = \App\Models\Setting::where('id', 1)->first(["name_" . $lang . " as name", "description_" . $lang . " as description"]);
        $data['trainer'] = Trainers::where('status', 1)->where('id', $id)->first();
        $data['courses'] = Course::where('lang', $lang_val[$lang])
            ->where('trainers', $id)
            ->with('category', 'trainer', 'universitie')
            ->orderBy('id', 'desc')
            ->get();


        $array_courses = Course::where('lang', $lang_val[$lang])->where('trainers', $id)->pluck('id')->ToArray();
        // if(in_array($a->id,$array_desired)){


        $data['rating'] = MyCourses::whereIn('my_courses.courses_id', [$array_courses])
            ->whereNotNull('my_courses.stars_no')
            ->leftJoin('clients as c', function ($join) {
                $join->on('c.id', '=', 'my_courses.client_id')->whereNull('c.deleted_at');
            })
            ->orderBy('my_courses.id', 'asc')
            ->select('my_courses.*', 'c.name as client_name', 'c.img as client_img')
            ->get();

        // return 'قيد البرمجة';
        return view('site.trainer', compact('data', 'setting'));
    }

    public function portal()
    {
        $lang            =   'ar';
        $lang_val        =    ['ar' => 1, 'en' => 2];

        $setting = \App\Models\Setting::where('id', 1)->first(["name_" . $lang . " as name", "description_" . $lang . " as description"]);
        $data['static'] = static_page::where('slug', 'login')->first(['id', "title_" . $lang . " as title", "details_" . $lang . " as details"]);

        return view('site.portal', compact('data', 'setting'));
    }
    public function checkout(Request $request)
    {
        $lang            =   'ar';
        $lang_val        =    ['ar' => 1, 'en' => 2];
        $id = $request->get('id');

        $data['courses'] = Course::where('lang', $lang_val[$lang])
            ->where('id', $id)
            ->with('category', 'trainer', 'universitie')
            ->orderBy('id', 'desc')
            ->first();

        $setting = \App\Models\Setting::where('id', 1)->first(["name_" . $lang . " as name", "description_" . $lang . " as description", 'moyasar_key']);

        if (Auth::guard('clients')->check()) {
            $client = (Auth::guard('clients')->user()->id);
            if ($client) {
                if ($id) {
                    $favorites = MyCourses::where('courses_id', $id)->where('client_id', $client)->first();
                    if ($favorites) {
                        return response()->json(['status' => false, 'data' => 'لقد تم التسجيل بالدورة مسبقا ']);
                    } else {
                        return response()->json(['status' => true]);

                        // return view('site.checkout', compact('data', 'setting'));
                    }
                } else {
                    return response()->json(['status' => false, 'data' => ' حدث خطأ ']);
                }
            } else {
                return response()->json(['status' => false, 'data' => trans('lang.error')]);
            }
        } else {
            return response()->json(['status' => false, 'x' => 1, 'data' => ' عليك تسجيل الدخول ']);
        }
    }
    public function checkout_page($id)
    {
        $lang            =   'ar';
        $lang_val        =    ['ar' => 1, 'en' => 2];

        $data['courses'] = Course::where('lang', $lang_val[$lang])
            ->where('id', $id)
            ->with('category', 'trainer', 'universitie')
            ->orderBy('id', 'desc')
            ->first();

        $setting = \App\Models\Setting::where('id', 1)->first(["name_" . $lang . " as name", "description_" . $lang . " as description", 'moyasar_key']);
        if (Auth::guard('clients')->check()) {
            $client = (Auth::guard('clients')->user()->id);
            if ($client) {
                if ($id) {
                    $favorites = MyCourses::where('courses_id', $id)->where('client_id', $client)->first();
                    if ($favorites) {
                        // return 123;
                        // return view('site.checkout', compact('data', 'setting'));
                    } else {
                        return view('site.checkout', compact('data', 'setting'));
                    }
                } else {
                    return response()->json(['status' => false, 'data' => ' حدث خطأ ']);
                }
            } else {
                return response()->json(['status' => false, 'data' => trans('lang.error')]);
            }
        } else {
            return response()->json(['status' => false, 'x' => 1, 'data' => ' عليك تسجيل الدخول ']);
        }
    }
    // 
    public function donation(Request $request)
    {


        $price = $request->get('price'); // المبلغ
        $number_ref = $request->get('number_ref');
        $order_id = $request->get('order_id');  // رقم فرصة التبرع

        $payment_method = $request->get('payment_method');
        $type_donation = $request->get('type_donation'); //   البنك
        $client = (Auth::guard('clients')->user()->id);
        if (Auth::guard('clients')->check()) {
        } else {
            return response()->json(['status' => false, 'x' => 1, 'data' => ' عليك تسجيل الدخول ']);
        }

        DB::beginTransaction();
        try {

            $favorites = new MyCourses();
            $favorites->client_id = $client;
            $favorites->courses_id = $order_id;
            $favorites->date = date('Y-m-d');
            $favorites->type = 1;
            $favorites->status = 1;
            $saved = $favorites->save();

            $d = new Donation();
            $favorites->client_id = $client;
            $d->price = $price;
            $d->status = 3;  // تم التحويل
            $d->date = date('Y-m-d');
            $d->payment_method = $payment_method;
            if ($number_ref) {
                $d->number_ref = $number_ref;
            }
            $d->order_id = $favorites->id;
            $d->type_donation = $type_donation;
            $saved = $d->save();


            DB::commit();
            return response()->json(['status' => true, 'data' => 'تمت العملية بنجاح']);
        } catch (\Exception $e) {
            DB::rollback();
            // return $e;
        }
        return response()->json(['status' => false, 'data' => ' حدث خطأ يرجى المحاولة مرة اخرى ']);
    }
    public function complete_payment(Request $request)
    {

        // return $request;
        $id = $request->get('id');
        $status = $request->get('status');
        $amount = $request->get('amount');
        $message = $request->get('message');

        $d = Donation::where('number_ref', $id)->first();
        $d->amount_pay = $amount;
        $d->status_pay = $status;
        $d->message_pay = $message;
        $d->save();
        $order_id = $d->order_id;
        return redirect('/profile#my_subscriptions');
    }


    public function video($id)
    {
        $lang            =   'ar';
        $lang_val        =    ['ar' => 1, 'en' => 2];
        $setting = \App\Models\Setting::where('id', 1)->first(["name_" . $lang . " as name", "description_" . $lang . " as description"]);
        $data['video'] = Video::where('id', $id)->first();
        return view('site.video', compact('data', 'setting'));
    }
    public function pdf($id)
    {
        $lang            =   'ar';
        $lang_val        =    ['ar' => 1, 'en' => 2];
        $setting = \App\Models\Setting::where('id', 1)->first(["name_" . $lang . " as name", "description_" . $lang . " as description"]);
        $data['pdf'] = Video::where('id', $id)->first();
        return view('site.pdf', compact('data', 'setting'));
    }
    // 






















































    public function courses($lang = 'ar')
    {
        if (!in_array($lang, ['ar', 'en'])) {
            abort(404);
        }
        \Session::put('locale', $lang);
        \App::setLocale(\Session::get('locale') ? \Session::get('locale') : $lang);
        $lang            =    \Session::get('locale') ? \Session::get('locale') : \App::getLocale();
        $lang_val        =    ['ar' => 1, 'en' => 2];
        $data['static'] = static_page::where('status', 1)->where('slug', 'academy_courses')->get(["title_" . $lang . " as title", "details_" . $lang . " as details", 'photo'])->first();
        $setting = \App\Models\Setting::where('id', 1)->first(["name_ar as name", "description_ar as description"]);
        if (!$data['static']) {
            abort(404);
        }
        $data['courses'] = Course::where('lang', $lang_val[$lang])->with('category')->orderBy('id', 'desc')->paginate(12);
        foreach ($data['courses'] as  $value) {
            $videos = Video::where('course_id', $value->id)->count();
            $value['videos_count'] = $videos;
        }
        return view('site.courses', compact('data', 'setting'));
    }





    public function lang($lang)
    {
        if ($lang == 'ar') {
            $pre_lang = 'en';
        } else {
            $pre_lang = 'ar';
        }
        if (app('router')->getRoutes()->match(app('request')->create(\URL::previous()))->getName() == 'site.home') {
            return redirect(\URL::to('/') . '/' . $lang);
        } else {
            $url = url()->previous();
            $url = str_replace('/' . $pre_lang, '/' . $lang, $url);
            return redirect($url);
        }
    }

    public function posts($lang = 'ar', $id = '')
    {
        // return 1;

        if (!in_array($lang, ['ar', 'en'])) {
            abort(404);
        }
        \Session::put('locale', $lang);
        \App::setLocale(\Session::get('locale') ? \Session::get('locale') : $lang);
        $lang            =    \Session::get('locale') ? \Session::get('locale') : \App::getLocale();
        $lang_val        =    ['ar' => 1, 'en' => 2];
        $setting = \App\Models\Setting::where('id', 1)->first(["name_ar as name", "description_ar as description"]);



        if ($id) {
            $data['posts'] = Posts::leftJoin('system_constants as sy', function ($join) {
                $join->on('sy.value', '=', 'posts.category')->where('sy.type', 'post_category')->whereNull('sy.deleted_at');
            })->where('posts.id', $id)->where('posts.status', 1)->with('tags', 'images')->select('posts.socil_images', 'posts.summarysocil_images', 'posts.summary', 'posts.socil_images_title', 'posts.description_image', 'posts.id', 'posts.details', 'posts.title', 'posts.views_no', 'posts.eshari', 'posts.main_image', "sy.name_ar as category_name", 'posts.date', 'posts.created_at', 'sy.value as category_id')->first();

            if ($data['posts'] == '') {
                abort(404);
            }
            $data['posts']->views_no =  $data['posts']->views_no + 1;
            $data['posts']->save();
            $data['reads'] = Posts::where('posts.id', '!=', $id)->where('posts.status', 1)->where('posts.lang', $lang_val[$lang])->where('posts.posts_id', '!=', 0)->orderBy('views_no', 'desc')->select('posts.id', 'posts.title', 'posts.main_image', 'posts.date')->take(3)->get();
            $data['category'] = System_Constants::where('type', 'post_category')->where('status', 1)->where('value', '!=', 1)->orderBy('value', 'asc')->get(["name_ar as name", 'value as id']);
            return view('site.post', compact('data', 'setting'));
        } else {
            $data['static'] = static_page::where('status', 1)->where('slug', 'academy_news')->get(["title_" . $lang . " as title", "details_" . $lang . " as details", 'photo'])->first();
            if (!$data['static']) {
                abort(404);
            }

            $data['news'] = Posts::leftJoin('system_constants as sy', function ($join) {
                $join->on('sy.value', '=', 'posts.category')->where('sy.type', 'post_category')->whereNull('sy.deleted_at');
            })->leftJoin('system_constants as sys', function ($join) {
                $join->on('sys.value', '=', 'posts.writers')->where('sys.type', 'writers')->whereNull('sys.deleted_at');
            })->where('posts.status', 1)->where('posts.lang', $lang_val[$lang])->where('posts_id', '!=', 0)
                ->select('posts.id as id', 'posts.category', 'sys.name_' . $lang . ' as writers',  'posts.title', 'posts.main_image', 'sy.name_' . $lang . ' as category_name', 'posts.date', 'posts.summary', 'posts.created_at', 'posts.eshari');


            $data['news'] = $data['news']->orderBy('posts.id', 'desc')->paginate(12);

            return view('site.posts', compact('data', 'setting'));
        }
    }

    public function tags($lang, $id)
    {

        $data['tags'] = Tag::where('id', $id)->first();
        if ($data['tags'] == '') {
            abort(404);
        }
        if ($lang == 'ar') {
            $lang_id = 1;
        } else if ($lang == 'en') {

            $lang_id = 2;
        }

        $data['posts'] = Posts::leftJoin('news_tag as t', function ($join) {
            $join->on('posts.id', '=', 't.news_id');
        })->where('posts.posts_id', '!=', 0)->where('posts.lang', $lang_id)->where('posts.status', 1)->where('t.tag_id', $id)->select('posts.id', 'posts.title', 'posts.main_image', 'posts.date')->get();

        return view('site.tags', compact('data'));
    }


    public function partners($lang = 'ar')
    {
        if (!in_array($lang, ['ar', 'en'])) {
            abort(404);
        }
        \Session::put('locale', $lang);
        \App::setLocale(\Session::get('locale') ? \Session::get('locale') : $lang);
        $lang            =    \Session::get('locale') ? \Session::get('locale') : \App::getLocale();
        $lang_val        =    ['ar' => 1, 'en' => 2];
        $data['static'] = static_page::where('slug', 'institutions')->first(['id', "title_" . $lang . " as title"]);
        $setting = \App\Models\Setting::where('id', 1)->first(["name_" . $lang . " as name", "description_" . $lang . " as description"]);
        if (!$data['static']) {
            abort(404);
        }

        $data['institutions'] = Institution::where('status', 1)
            ->select('id', "title_" . $lang . " as title", 'status', 'photo', 'url')
            ->orderBy('id', 'desc')->get();

        return view('site.partners', compact('data', 'setting'));
    }



    public function view_registr($lang = 'ar')
    {
        if (!in_array($lang, ['ar', 'en'])) {
            abort(404);
        }
        \Session::put('locale', $lang);
        \App::setLocale(\Session::get('locale') ? \Session::get('locale') : $lang);
        $lang            =    \Session::get('locale') ? \Session::get('locale') : \App::getLocale();
        $lang_val        =    ['ar' => 1, 'en' => 2];

        $setting = \App\Models\Setting::where('id', 1)->first(["name_" . $lang . " as name", "description_" . $lang . " as description"]);
        $data['static'] = static_page::where('slug', 'registr')->first(['id', "title_" . $lang . " as title", "details_" . $lang . " as details"]);
        // constants
        $system = new System_Constants();
        $data['governorate'] = $system->constants('governorate');
        $data['Degree'] = $system->constants('Degree');
        return view('site.registr', compact('data', 'setting'));
    }

    public function get_city($lang = 'ar', Request $request)
    {
        if (!in_array($lang, ['ar', 'en'])) {
            abort(404);
        }
        \Session::put('locale', $lang);
        \App::setLocale(\Session::get('locale') ? \Session::get('locale') : $lang);
        $lang            =    \Session::get('locale') ? \Session::get('locale') : \App::getLocale();
        $lang_val        =    ['ar' => 1, 'en' => 2];
        $id = $request->get('id');

        $setting = \App\Models\Setting::where('id', 1)->first(["name_" . $lang . " as name", "description_" . $lang . " as description"]);
        $data['static'] = static_page::where('slug', 'registr')->first(['id', "title_" . $lang . " as title", "details_" . $lang . " as details"]);
        // constants
        $system = new System_Constants();
        $data['governorate'] = $system->constants('governorate');
        $item = System_Constants::where('system_constants.type', 'city')
            ->where('system_constants.status', 1)
            ->where('system_constants.value3', $id)
            ->select('value as id', "name_$lang as name", "type", "photo as image", 'value3')
            ->get();
        $options = '';
        $options .= '<option value=""> ' . trans('app.city') . '</option>';
        foreach ($item as $constant) {
            $options .= '<option value="' . $constant->id . '">' . $constant->name . '</option>';
        }
        return response()->json(['status' => true, 'data' => $options]);
    }


    public function contact_view($lang = 'ar')
    {
        if (!in_array($lang, ['ar', 'en'])) {
            abort(404);
        }
        \Session::put('locale', $lang);
        \App::setLocale(\Session::get('locale') ? \Session::get('locale') : $lang);
        $lang            =    \Session::get('locale') ? \Session::get('locale') : \App::getLocale();
        $lang_val        =    ['ar' => 1, 'en' => 2];
        $data['static'] = static_page::where('slug', 'contact_us')->first(['id', "title_" . $lang . " as title"]);
        $setting = \App\Models\Setting::where('id', 1)->first(["name_ar as name", "description_ar as description"]);
        if (!$data['static']) {
            abort(404);
        }

        return view('site.contact_us', compact('data', 'setting'));
    }



    public function search($lang = 'ar', Request $request)
    {

        if (!in_array($lang, ['ar', 'en'])) {
            abort(404);
        }
        \Session::put('locale', $lang);
        \App::setLocale(\Session::get('locale') ? \Session::get('locale') : $lang);
        $lang            =    \Session::get('locale') ? \Session::get('locale') : \App::getLocale();
        $lang_val        =    ['ar' => 1, 'en' => 2];
        //  return $lang_val[$lang];
        $search = $request->get('search');
        if ($search  == '') {
        }
        $search_str = "%" . str_replace(" ", "%", trim($search)) . "%";
        $result_array = Tag::where('tags.name', 'LIKE', $search_str)
            ->where('tags.status', 1)
            ->pluck('id')->ToArray();

        $tags1 = Posts::where(function ($query) use ($search_str) {
            $query->where('posts.title', 'LIKE', $search_str)
                ->orwhere('posts.details', 'LIKE', $search_str);
        })->leftJoin('system_constants as s', function ($join) {
            $join->on('s.value', '=', 'posts.category')->where('s.type', 'post_category')->whereNull('s.deleted_at');
        })->where('posts.status', 1)
            ->where('posts.lang', $lang_val[$lang])
            ->where('posts.posts_id', '!=', 0)
            ->select(['posts.id', 'posts.title', 'posts.main_image', 'posts.date', 's.name_ar as category_name'])
            ->selectRaw('1 as post_type');



        $tags2 = NewsTags::whereIn('tag_id', $result_array)
            ->leftJoin('posts as t', function ($join) {
                $join->on('t.id', '=', 'news_tag.news_id');
            })->leftJoin('system_constants as sy', function ($join) {
                $join->on('sy.value', '=', 't.category')->where('sy.type', 'post_category')->whereNull('sy.deleted_at');
            })->where('t.posts_id', '!=', 0)->where('t.lang', $lang_val[$lang])
            ->select(['t.id', 't.title', 't.main_image', 't.date', 'sy.name_ar as category_name'])
            ->selectRaw('1 as post_type');



        $tags = Course::where(function ($query) use ($search_str) {
            $query->where('courses.title', 'LIKE', $search_str)
                ->orwhere('courses.details', 'LIKE', $search_str);
        })->leftJoin('system_constants as syst', function ($join) {
            $join->on('syst.value', '=', 'courses.category_id')->where('syst.type', 'courses_category')->whereNull('syst.deleted_at');
        })
            ->where('courses.lang', $lang_val[$lang])
            ->where('courses.status', 1)
            ->select(['courses.id', 'courses.title', 'courses.image as main_image', 'courses.created_at as date', 'syst.name_ar as category_name'])
            ->selectRaw('2 as post_type')
            ->union($tags1)
            ->union($tags2)
            // ->toSql();
            ->get();

        // return  $tags;
        $data['posts'] = $tags;

        $setting = \App\Models\Setting::where('id', 1)->first(["name_ar as name", "description_ar as description"]);
        return view('site.search', compact(['data', 'search', 'setting']));
    }







    public function sitemap()
    {




        $data['posts'] = Posts::where('status', 1)
            ->orderBy('id', 'desc')
            ->select(['id', 'title', 'details', 'created_at', 'lang'])
            ->take(300)
            ->get();
        $data['courses'] = Course::where('status', 1)->orderBy('id', 'desc')->take(300)->get(['id', 'title', 'created_at', 'details', 'lang']);


        // @ob_start();

        header('Content-Type: application/xml; charset=utf-8');

        header("Content-type: text/xml");

        echo '<?xml version="1.0" standalone="yes"?>';

        echo '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">

            <url>

                <loc>' . \URL::to('/') . "/" . \App::getLocale() . '</loc>

                <priority>1.0</priority>

                <changefreq>daily</changefreq>

            </url>';

        foreach ($data['posts'] as $posts) {
            if ($posts->lang == 1) {
                $lang = 'ar';
            } else {
                $lang = 'en';
            }

            echo '<url>
    
                        <loc>' . \URL::to('/') . "/" . $lang . '/posts/' . $posts->id . '/' . \App\Http\Helpers\Helpers::stringReplace($posts->title, 2) . '</loc>
    
                        <lastmod>' . date("c", strtotime($posts->created_at)) . '</lastmod>
    
                        <priority>0.8</priority>
    
                        <changefreq>daily</changefreq>
    
                    </url>';
        }
        foreach ($data['courses'] as $courses) {
            if ($courses->lang == 1) {
                $lang = 'ar';
            } else {
                $lang = 'en';
            }
            echo '<url>

                    <loc>' . \URL::to('/') . "/" . $lang . '/cours/' . $courses->id . '/' . \App\Http\Helpers\Helpers::stringReplace($courses->title, 2) . '</loc>

                    <lastmod>' . date("c", strtotime($courses->created_at)) . '</lastmod>

                    <priority>0.8</priority>

                    <changefreq>daily</changefreq>

                </url>';
        }





        echo '</urlset>';
        exit;
    }


    public function rss()
    {

        $setting = \App\Models\Setting::where('id', 1)->first(["name_ar as name", "description_ar as description"]);



        header("content-type: text/xml;charset=utf-8");

        $data['posts'] = Posts::where('status', 1)->orderBy('id', 'desc')->take(300)->get(['id', 'title', 'details', 'created_at', 'lang']);
        $data['courses'] = Course::where('status', 1)->orderBy('id', 'desc')->take(300)->get(['id', 'title', 'details', 'created_at', 'lang']);

        echo '<rss version="2.0">

          <channel>

           <title>' . $setting->name . '</title>

          <link>' . \URL::to('/') . '</link>

          <description>' . $setting->name . '</description>

          <pubDate>' . date('Y-m-d') . 'T' . date('H:i:s') . '+02:00</pubDate>';



        foreach ($data['posts'] as $posts) {
            if ($posts->lang == 1) {
                $lang = 'ar';
            } else {
                $lang = 'en';
            }

            echo '<item>

                        <title>' . trim($posts->title) . '</title>

                        <link>' . \URL::to('/') . $lang . '/posts/' . $posts->id . '/' . \App\Http\Helpers\Helpers::stringReplace($posts->title, 2) . '</link>

                        <description>' . \App\Http\Helpers\Helpers::cutText(\App\Http\Helpers\Helpers::stringReplace($posts->details, 3), 400, false) . '</description>

                        <pubDate>' . date('Y-m-d', strtotime($posts->created_at)) . 'T' . date('H:i:s', strtotime($posts->created_at)) . '+02:00</pubDate>

            </item>';
        }
        foreach ($data['courses'] as $courses) {
            if ($courses->lang == 1) {
                $lang = 'ar';
            } else {
                $lang = 'en';
            }

            echo '<item>

                        <title>' . trim($courses->title) . '</title>

                        <link>' . \URL::to('/') . $lang . '/posts/' . $courses->id . '/' . \App\Http\Helpers\Helpers::stringReplace($courses->title, 2) . '</link>

                        <description>' . \App\Http\Helpers\Helpers::cutText(\App\Http\Helpers\Helpers::stringReplace($courses->details, 3), 400, false) . '</description>

                        <pubDate>' . date('Y-m-d', strtotime($courses->created_at)) . 'T' . date('H:i:s', strtotime($courses->created_at)) . '+02:00</pubDate>

            </item>';
        }

        echo ' </channel></rss>';
        exit;
    }






    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    // public function notifications()
    // {
    //     $notifications = Notifications::where('is_send', 0)->where('date_time', '<=', date('Y-m-d H:i:s'))->get(['id', 'title', 'image', 'description', 'type']);
    //     if ($notifications) {
    //         foreach ($notifications as $notification) {
    //             $notification->is_send = 1;
    //             $notification->save();
    //             \App\Http\Helpers\Helpers::sendFcmNotification($notification->title, $notification->description, $notification->type, array());
    //         }
    //     }
    // }
}
