<?php

namespace App\Http\Controllers\Admin;

use App\Models\Trainers as MyModel;
use App\Models\System_Constants;
use App\Models\Universities;
use Illuminate\Http\Request;


class TrainersController extends AdminController
{
    public function __construct()
    {
    }
    //////////////////////////////////////////////
    public function index(Request $request)
    {

        $data['trainers'] = MyModel::orderBy('id', 'desc')->paginate(15);
        $data['universities'] = Universities::orderBy('id', 'desc')->get();


        $data['system'] = System_Constants::where('status', 1)->where('type', 'lang')->select("value2", "name_ar as name")->get();
        if ($request->ajax()) {
            return view('admin.trainers.table-data', compact('data'))->render();
        }
        return view('admin.trainers.index', compact('data'));
    }
    /***********************************************************************************************************************/
    public function add(Request $request)
    {

        $hidden = $request->get('hidden');
        if ($hidden == 0) {
            $user_id = \Auth::user()->id;
            $title_ar = $request->get('title_ar');
            $details_ar = $request->get('details_ar');
            $title_en = $request->get('title_en');
            $details_en = $request->get('details_en');

            $username = $request->get('username');
            $mobile = $request->get('mobile');
            $universities = $request->get('universities');
            $password = $request->get('password');

            if (isset($request['activeValue'])) {
                $status = 1;
            } else {
                $status = 0;
            }
            $file = $request->get('image');

            $rules = [
                'title' => 'required',
                'details' => 'required',
                'mobile' => 'required',
                // 'username' => 'required',
                'universities' => 'required',
                'password' => 'required',
                'file' => 'required',

            ];

            $messages = [
                'title.required' => 'العنوان  مطلوب',
                'details.required' => 'التفاصيل مطلوبة',
                'mobile.required' => 'رقم الجوال مطلوب',
                // 'username' => ' اسم المستخدم مطلوب',
                'universities.required' => 'الجامعة مطلوبة',
                'password.required' => 'كلمة المرور مطلوبة',
                'file.required' => 'الصورة مطلوبة',

            ];

            $validator = \Validator::make(
                [
                    'title' => $title_ar,
                    'details' => $details_ar,
                    'mobile' => $mobile,
                    // 'username' => $username,
                    'universities' => $universities,
                    'password' => $password,
                    'file' => $file,

                ],
                $rules,
                $messages
            );



            if ($validator->fails()) {
                return response()->json(['status' => false, 'data_validator' => $validator->messages()]);
            }


            // if ($validator->fails()) {
            //     $all = collect($validator->errors()->getMessages())->map(function ($item) {
            //         return $item[0];
            //     });
            //     $strs = [];
            //     foreach ($all as $value) {
            //         $strs[] =  $value;
            //     }
            //     return response()->json(['status' => false, 'data' => implode(',', $strs)]);
            // }

            $item = new MyModel();
            $item->user_id = $user_id;
            $item->title_ar = $title_ar;
            $item->details_ar = $details_ar;
            $item->title_en = $title_en;
            $item->details_en = $details_en;
            $item->status = $status;
            $item->photo = $file;

            $item->mobile = $mobile;
            $item->universities = $universities;
            $item->password = \Hash::make($password);
            $item->pass = $password;

            $saved = $item->save();
            if (!$saved) {
                return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
            }
            return response()->json(['status' => true, 'data' => 'تمت عملية الإضافة']);
        } else {
            return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء عملية الإضافة']);
        }
    }
    /***********************************************************************************************************************/
    public function edit(Request $request)
    {

        $id = $request->get('id');
        $item = MyModel::find($id);
        if ($item != '') {
            return response()->json(['status' => true, 'data' => $item]);
        } else {
            return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
        }
    }

    /***********************************************************************************************************************/

    public function UpdateStats(Request $request)
    {

        $id = $request->get('id');
        $item = MyModel::find($id);
        if ($item != '') {
            if ($item->status == 0) {
                $item->status = 1;
            } else {
                $item->status = 0;
            }
            $saved = $item->save();
            if (!$saved) {
                return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
            }
            return response()->json(['status' => true, 'data' => 'تم تعديل الحالة']);
        } else {
            return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
        }
    }
    /***********************************************************************************************************************/
    public function update(Request $request)
    {

        $hidden = $request->get('hidden');

        if ($hidden != 0) {
            $user_id = \Auth::user()->id;
            $slug = $request->get('slug');
            $file = $request->get('image');
            $title_ar = $request->get('title_ar');
            $details_ar = $request->get('details_ar');
            $title_en = $request->get('title_en');
            $details_en = $request->get('details_en');


            $username = $request->get('username');
            $mobile = $request->get('mobile');
            $universities = $request->get('universities');
            $password = $request->get('password');

            if (isset($request['activeValue'])) {
                $status = 1;
            } else {
                $status = 0;
            }

            $rules = [
                'title' => 'required',
                'details' => 'required',
                'mobile' => 'required',
                // 'username' => 'required',
                'universities' => 'required',
                'password' => 'required',
                // 'file' => 'required',
            ];

            $messages = [
                'title.required' => 'العنوان  مطلوب',
                'details.required' => 'التفاصيل مطلوبة',
                'mobile.required' => 'رقم الجوال مطلوب',
                // 'username' => ' اسم المستخدم مطلوب',
                'universities.required' => 'الجامعة مطلوبة',
                'password.required' => 'كلمة المرور مطلوبة',
                // 'file.required' => 'الصورة مطلوبة',
            ];

            $validator = \Validator::make(
                [
                    'title' => $title_ar,
                    'details' => $details_ar,
                    'mobile' => $mobile,
                    // 'username' => $username,
                    'universities' => $universities,
                    'password' => $password,
                    // 'file' => $file,
                ],
                $rules,
                $messages
            );

            // if ($validator->fails()) {
            //     $all = collect($validator->errors()->getMessages())->map(function ($item) {
            //         return $item[0];
            //     });
            //     $strs = [];
            //     foreach ($all as $value) {
            //         $strs[] =  $value;
            //     }
            //     return response()->json(['status' => false, 'data' => implode(',', $strs)]);
            // }

            if ($validator->fails()) {
                return response()->json(['status' => false, 'data_validator' => $validator->messages()]);
            }

            $item = MyModel::find($hidden);


            if ($item != '') {
                $item->user_id = $user_id;
                $item->status = $status;
                $item->title_ar = $title_ar;
                $item->details_ar = $details_ar;
                $item->title_en = $title_en;
                $item->details_en = $details_en;
                if ($file != '') {
                    $item->photo = $file;
                }
                $item->username = $username;
                $item->mobile = $mobile;
                $item->universities = $universities;
                $item->password = \Hash::make($password);
                $item->pass = $password;
                $saved = $item->save();
                if (!$saved) {
                    return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
                }
                return response()->json(['status' => true, 'data' => 'تم تعديل البيانات']);
            } else {
                return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
            }
        }
    }

    public function delete(Request $request)
    {

        $id = $request->get('id');
        $item = MyModel::find($id);
        if ($item != '') {
            $deleted = $item->delete();
            if (!$deleted) {
                return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
            }
            return response()->json(['status' => true, 'data' => 'تم الحذف بنجاح']);
        } else {
            return response()->json(['status' => false, 'data' => 'حدث خطأ أثناء العملية']);
        }
    }
}
