<?php

namespace App\Http\Controllers\Admin;

use App\Models\static_page as MyModel;
use App\Models\Partners;
use App\Models\System_Constants;
use Illuminate\Http\Request;


class StaticPageController extends AdminController
{
    public function __construct(){
    }
    //////////////////////////////////////////////
    public function index(Request $request)
    {
        $data['static'] = MyModel::orderBy('id','desc')->paginate(15);
        $data['system'] = System_Constants::where('status',1)->where('type','lang')->select("value2","name_ar as name")->get();
        if ($request->ajax()) {
            return view('admin.static_page.table-data', compact('data'))->render();
        }
        return view('admin.static_page.index',compact('data'));
    }
  /***********************************************************************************************************************/
    public function add(Request $request){
        $hidden = $request->get('hidden');
        if($hidden == 0){
            $user_id = \Auth::user()->id;
            $slug = $request->get('slug');
            $title_ar = $request->get('title_ar');
            $details_ar = $request->get('details_ar');
            $title_en = $request->get('title_en');
            $details_en = $request->get('details_en');
            if(isset($request['activeValue'])){
                $status = 1;
            }else{
                $status = 0;
            }
            $file = $request->get('image');

            $rules = [
                'title' => 'required',
                // 'details' => 'required',
                'slug' => 'required',
            ];
    
            $messages = [
                'title.required' => 'العنوان  مطلوب',
                // 'details.required' => 'التفاصيل مطلوبة',
                'slug.required' => 'slug مطلوبة',
            ];
    
            $validator = \Validator::make([
                'title' => $title_ar,
                // 'details' => $details_ar,
                'slug' => $slug,
            ],
                $rules
                ,
                $messages
            );
    


            if ($validator->fails()) {
                $all = collect($validator->errors()->getMessages())->map(function($item){
                    return $item[0];
                });
                  $strs = [];
                foreach ($all as $value) {
                    $strs[]=  $value;
                }
                return response()->json(['status' => false , 'data' => implode(',',$strs)]);
            }
    
            if($slug != ''){
                if(preg_match('/[^A-Za-z0-9-_]/', $slug)){
                    return response()->json(['status' => false , 'data' => 'الرجاء التأكد من صيغة slug']);
                }
            }

            if($slug != 'splash'){
                $count = MyModel::where('slug',$slug)->count();
                if($count > 0){
                    return response()->json(['status' => false , 'data' => 'slug مستخدم من قبل']);
                }
            }
    
    
            $item = new MyModel();
            $item->user_id = $user_id;
            $item->title_ar = $title_ar;
            $item->details_ar = $details_ar;
            $item->title_en = $title_en;
            $item->details_en = $details_en;
            $item->slug = $slug;
            $item->status = $status;
            $item->photo = $file;
            $item->delete_flag = 0;

            
            $saved = $item->save();
            if (!$saved) {
                return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء عملية الإضافة']);
            }
            return response()->json(['status' => true , 'data' => 'تمت عملية الإضافة']);
        }else{
            return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء عملية الإضافة']);
        }
        

    }
/***********************************************************************************************************************/
    public function edit(Request $request){
      
        $id = $request->get('id');
            $item = MyModel::find($id);
            if($item != ''){
                return response()->json(['status' => true , 'data' => $item]);
            }else{
                return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء العملية']);
            }
    }

    /***********************************************************************************************************************/

    public function UpdateStats(Request $request){
      
        $id = $request->get('id');
        $item = MyModel::find($id);
            if($item != ''){
                if($item->status == 0){
                    $item->status = 1;
                }else{
                    $item->status = 0;
                }
                $saved = $item->save();
                if(!$saved){
                    return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء العملية']);
                }
                return response()->json(['status' => true , 'data' => 'تم تعديل الحالة']);
            }else{
                return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء العملية']);
            }
    }
/***********************************************************************************************************************/
    public function update(Request $request){
     
        $hidden = $request->get('hidden');

        if($hidden != 0){
            $user_id = \Auth::user()->id;
            $slug = $request->get('slug');
            $file = $request->get('image');
            $title_ar = $request->get('title_ar');
            $details_ar = $request->get('details_ar');
            $title_en = $request->get('title_en');
            $details_en = $request->get('details_en');
            if(isset($request['activeValue'])){
                $status = 1;
            }else{
                $status = 0;
            }

            $rules = [
                'title' => 'required',
                // 'details' => 'required',
                // 'slug' => 'required',
            ];
    
            $messages = [
                'title.required' => 'العنوان  مطلوب',
                // 'details.required' => 'التفاصيل مطلوبة',
                // 'slug.required' => 'الرابط مطلوبة',
            ];
    
            $validator = \Validator::make([
                'title' => $title_ar,
                // 'details' => $details_ar,
                // 'slug' => $slug,
            ],
                $rules
                ,
                $messages
            );
    
            if ($validator->fails()) {
                $all = collect($validator->errors()->getMessages())->map(function($item){
                    return $item[0];
                });
                  $strs = [];
                foreach ($all as $value) {
                    $strs[]=  $value;
                }
                return response()->json(['status' => false , 'data' => implode(',',$strs)]);
            }
            $item = MyModel::find($hidden); 
            if($item->delete_flag == 0){
                if($slug == ''){
                        return response()->json(['status' => false , 'data' => 'slug مطلوب ']);
                }
                if($slug != ''){
                    if(preg_match('/[^A-Za-z0-9-_]/', $slug)){
                        return response()->json(['status' => false , 'data' => 'الرجاء التأكد من صيغة slug']);
                    }
                }
                if($slug != 'splash'){
                    $count = MyModel::where('slug',$slug)->where('id','!=',$hidden)->count();
                    if($count > 0){
                        return response()->json(['status' => false , 'data' => 'slug مستخدم من قبل']);
                    }
                }
            }
        
          
            if($item != ''){
                $item->user_id = $user_id;
                $item->status = $status;
                $item->title_ar = $title_ar;
                $item->details_ar = $details_ar;
                $item->title_en = $title_en;
                $item->details_en = $details_en;
                if($item->delete_flag == 0){
                    $item->slug = $slug;
                }
                if($file != ''){
                    $item->photo = $file;
                }
                $saved = $item->save();
                if(!$saved){
                    return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء العملية']);
                }
                return response()->json(['status' => true , 'data' => 'تم تعديل البيانات']);
            }else{
                return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء العملية']);
            }

        }
    }

    public function delete(Request $request){
     
        $id = $request->get('id');
        $item = MyModel::find($id);
        if($item != ''){
            if($item->delete_flag == 1){
                return response()->json(['status' => false , 'data' => 'لا يمكن حذف العنصر']);
            }
            $deleted = $item->delete();
            if(!$deleted){
                return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء العملية']);
            }
            return response()->json(['status' => true , 'data' => 'تم الحذف بنجاح']);
        }else{
            return response()->json(['status' => false , 'data' => 'حدث خطأ أثناء العملية']);
        }

    }
}